/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.CredentialsAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.NoneAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.NullAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.TokenAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.exceptions.CredentialsNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class Auth
extends AbstractDescribableImpl<Auth>
implements Serializable {
    private static final long serialVersionUID = 5110932168554914718L;
    public static final String NONE = "none";
    public static final String API_TOKEN = "apiToken";
    public static final String CREDENTIALS_PLUGIN = "credentialsPlugin";
    private final String authType;
    private final String username;
    private final String apiToken;
    private final String creds;

    @DataBoundConstructor
    public Auth(String authType, String username, String apiToken, String creds) {
        this.authType = authType;
        this.username = username;
        this.apiToken = apiToken;
        this.creds = creds;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public String getCreds() {
        return this.creds;
    }

    public Boolean isMatch(String value) {
        return this.authType.equals(value);
    }

    public String getUser() {
        if (this.authType.equals(API_TOKEN)) {
            return this.username;
        }
        if (this.authType.equals(CREDENTIALS_PLUGIN)) {
            UsernamePasswordCredentials creds = this.getCredentials();
            return creds != null ? creds.getUsername() : "";
        }
        return "";
    }

    public String getPassword() {
        if (this.authType.equals(API_TOKEN)) {
            return this.apiToken;
        }
        if (this.authType.equals(CREDENTIALS_PLUGIN)) {
            UsernamePasswordCredentials creds = this.getCredentials();
            return creds != null ? creds.getPassword().getPlainText() : "";
        }
        return "";
    }

    private UsernamePasswordCredentials getCredentials() {
        Item item = null;
        List listOfCredentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, item, (Authentication)ACL.SYSTEM, Collections.emptyList());
        return (UsernamePasswordCredentials)this.findCredential(this.creds, listOfCredentials);
    }

    private StandardUsernameCredentials findCredential(String credetialId, List<StandardUsernameCredentials> listOfCredentials) {
        for (StandardUsernameCredentials cred : listOfCredentials) {
            if (!credetialId.equals(cred.getId())) continue;
            return cred;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static Auth auth2ToAuth(Auth2 auth) {
        if (auth == null) {
            return null;
        }
        if (auth instanceof NoneAuth) {
            return new Auth(NONE, null, null, null);
        }
        if (auth instanceof TokenAuth) {
            TokenAuth tokenAuth = (TokenAuth)auth;
            return new Auth(API_TOKEN, tokenAuth.getUserName(), tokenAuth.getApiToken().getPlainText(), null);
        }
        if (auth instanceof CredentialsAuth) {
            CredentialsAuth credAuth = (CredentialsAuth)auth;
            try {
                String credUser = credAuth.getUserName(null);
                String credPass = credAuth.getPassword(null);
                return new Auth(CREDENTIALS_PLUGIN, credUser, credPass, credAuth.getCredentials());
            }
            catch (CredentialsNotFoundException e) {
                return new Auth(CREDENTIALS_PLUGIN, "", "", credAuth.getCredentials());
            }
        }
        return null;
    }

    public static Auth2 authToAuth2(List<Auth> oldAuth) {
        if (oldAuth == null || oldAuth.size() <= 0) {
            return NullAuth.INSTANCE;
        }
        return Auth.authToAuth2(oldAuth.get(0));
    }

    public static Auth2 authToAuth2(Auth oldAuth) {
        String authType = oldAuth.getAuthType();
        if (NONE.equals(authType)) {
            return NoneAuth.INSTANCE;
        }
        if (API_TOKEN.equals(authType)) {
            TokenAuth newAuth = new TokenAuth();
            newAuth.setUserName(oldAuth.getUsername());
            newAuth.setApiToken(Secret.fromString((String)oldAuth.getApiToken()));
            return newAuth;
        }
        if (CREDENTIALS_PLUGIN.equals(authType)) {
            CredentialsAuth newAuth = new CredentialsAuth();
            newAuth.setCredentials(oldAuth.getCreds());
            return newAuth;
        }
        return NullAuth.INSTANCE;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Auth> {
        public String getDisplayName() {
            return "";
        }

        public static ListBoxModel doFillCredsItems() {
            StandardUsernameListBoxModel model = new StandardUsernameListBoxModel();
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            List listOfAllCredentails = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList());
            ArrayList<StandardUsernameCredentials> listOfSandardUsernameCredentials = new ArrayList<StandardUsernameCredentials>();
            for (StandardUsernameCredentials c : listOfAllCredentails) {
                if (!(c instanceof UsernamePasswordCredentials)) continue;
                listOfSandardUsernameCredentials.add(c);
            }
            model.withAll(listOfSandardUsernameCredentials);
            return model;
        }
    }
}

