/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.jwtauth.impl;

import hudson.Extension;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import org.conjur.jenkins.configuration.GlobalConjurConfiguration;
import org.conjur.jenkins.jwtauth.JwtAuthenticationService;
import org.conjur.jenkins.jwtauth.impl.JwtToken;
import org.springframework.web.HttpRequestMethodNotSupportedException;

@Extension
public class JwtAuthenticationServiceImpl
extends JwtAuthenticationService {
    private static final Logger LOGGER = Logger.getLogger(JwtAuthenticationServiceImpl.class.getName());
    private static final String DISPLAY_NAME = "Conjur JWT endpoint";

    @Override
    public String getJwkSet() throws HttpRequestMethodNotSupportedException {
        try {
            GlobalConjurConfiguration result = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
            if (result == null) {
                throw new HttpRequestMethodNotSupportedException("conjur-jwk-set");
            }
            return JwtToken.getJwkset().toString(4);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            return null;
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

