/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.ModelObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;

public class ConjurCredentialsSupplier
implements Supplier<Collection<StandardCredentials>> {
    private static final Logger LOGGER = Logger.getLogger(ConjurCredentialsSupplier.class.getName());
    private ModelObject context;

    private ConjurCredentialsSupplier(ModelObject context) {
        this.context = context;
    }

    public static Supplier<Collection<StandardCredentials>> standard(ModelObject context) {
        return new ConjurCredentialsSupplier(context);
    }

    private ModelObject getContext() {
        return this.context;
    }

    @Override
    @SuppressFBWarnings
    public Collection<StandardCredentials> get() {
        if (this.getContext() == null) {
            return Collections.emptyList();
        }
        Collection<Object> allCredentials = new ArrayList();
        try {
            allCredentials = ConjurAPI.getCredentialsForContext(StandardCredentials.class, this.getContext());
            if (allCredentials != null) {
                for (Credentials credentials : allCredentials) {
                    if (!(credentials instanceof ConjurSecretCredentials)) continue;
                    ((ConjurSecretCredentials)credentials).setStoredInConjurStorage(true);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("EXCEPTION: ConjurCredentialsSupplier: returned %s", e.getMessage()));
        }
        return allCredentials;
    }
}

