/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.credentials;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.credentials.ConjurCredentialStore;
import org.conjur.jenkins.credentials.ConjurCredentialsSupplier;
import org.conjur.jenkins.credentials.ConjurCustomSuppliers;

@Extension(optional=true, ordinal=1.0)
public class ConjurCredentialProvider
extends CredentialsProvider {
    private static final Logger LOGGER = Logger.getLogger(ConjurCredentialProvider.class.getName());
    private static final ConcurrentHashMap<String, Supplier<Collection<StandardCredentials>>> allCredentialSuppliers = new ConcurrentHashMap();

    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull ItemGroup itemGroup, @NonNull Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentialsFromSupplier(type, (ModelObject)itemGroup, authentication);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @NonNull Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentialsFromSupplier(type, (ModelObject)item, authentication);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, ItemGroup itemGroup, Authentication authentication) {
        return this.getCredentialsFromSupplier(type, (ModelObject)itemGroup, authentication);
    }

    <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, ModelObject context) {
        ArrayList creds = new ArrayList();
        try {
            Collection<StandardCredentials> addNewCredentials;
            this.getStore(context);
            Supplier<Collection<StandardCredentials>> currentCredentialSupplier = allCredentialSuppliers.get(String.valueOf(context.hashCode()));
            if (currentCredentialSupplier != null && (addNewCredentials = currentCredentialSupplier.get()) != null) {
                creds.addAll(addNewCredentials.stream().filter(c -> type.isAssignableFrom(c.getClass())).map(type::cast).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Getting credentials failed. Exception: %s", e.toString()));
        }
        return creds;
    }

    private <C extends Credentials> List<C> getCredentialsFromSupplier(@NonNull Class<C> type, ModelObject context, Authentication authentication) {
        ArrayList<C> creds = new ArrayList<C>();
        LOGGER.log(Level.FINEST, String.format("getCredentialsFromSupplier type: %s context: %s", type.toString(), context.getDisplayName()));
        ItemGroup locg = null;
        if (ACL.SYSTEM.equals(authentication)) {
            if (context instanceof AbstractFolder) {
                locg = (ItemGroup)context;
            } else if (context instanceof Item) {
                locg = ((Item)context).getParent();
                creds.addAll(this.getCredentials(type, context));
                if (!ConjurAPI.isInheritanceOn(context)) {
                    return creds;
                }
            }
            if (!(context instanceof Hudson)) {
                ItemGroup g = locg;
                while (g instanceof AbstractFolder) {
                    creds.addAll(this.getCredentials(type, (ModelObject)g));
                    if (!ConjurAPI.isInheritanceOn((ModelObject)g)) {
                        LOGGER.log(Level.FINEST, String.format("Inheritance stopped on %s", g.getFullName()));
                        break;
                    }
                    g = ((AbstractFolder)AbstractFolder.class.cast(g)).getParent();
                }
            }
            try {
                creds.addAll(this.getCredentials(type, (ModelObject)Jenkins.get()));
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.FINEST, String.format("Getting global credentials exception: %s", e.toString()));
            }
        }
        LOGGER.log(Level.FINEST, String.format("Return credentials: %d", creds.size()));
        return creds;
    }

    public ConjurCredentialStore getStore(ModelObject object) {
        ConjurCredentialStore store = null;
        Supplier<Collection<StandardCredentials>> supplier = null;
        if (object != null) {
            String key = String.valueOf(object.hashCode());
            try {
                if (ConjurCredentialStore.isStoreContainsKey(key)) {
                    LOGGER.log(Level.FINEST, String.format("GetStore EXISTING ConjurCredentialProvider: %s object %s hash %s", object.getClass().getName(), object.toString(), object.hashCode()));
                    store = ConjurCredentialStore.getCredentialStore(key);
                } else {
                    LOGGER.log(Level.FINEST, String.format("GetStore CREATE, key: %s object %s", key, object.toString()));
                    store = new ConjurCredentialStore(this, object);
                    supplier = ConjurCredentialProvider.memoizeWithExpiration(ConjurCredentialsSupplier.standard(object), Duration.ofSeconds(120L));
                    ConjurCredentialStore.putCredentialStore(key, store);
                    allCredentialSuppliers.put(key, supplier);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, String.format("There is a problem with Storage: %s", ex.getMessage()));
            }
        }
        return store;
    }

    public static ConcurrentMap<String, Supplier<Collection<StandardCredentials>>> getAllCredentialSuppliers() {
        return allCredentialSuppliers;
    }

    public String getIconClassName() {
        return "icon-conjur-credentials-store";
    }

    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> base, Duration duration) {
        return ConjurCustomSuppliers.memoizeWithExpiration(base, duration);
    }

    public static ConjurCredentialStore putCredentials(ConjurCredentialProvider ccp, ModelObject object, String key) {
        ConjurCredentialStore store = new ConjurCredentialStore(ccp, object);
        Supplier<Collection<StandardCredentials>> supplier = ConjurCredentialProvider.memoizeWithExpiration(ConjurCredentialsSupplier.standard(object), Duration.ofSeconds(120L));
        ConjurCredentialStore.putCredentialStore(key, store);
        allCredentialSuppliers.put(key, supplier);
        return store;
    }
}

