/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.conjur.jenkins.conjursecrets.ConjurSecretStringCredentials;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.Binding;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConjurSecretStringCredentialsBinding
extends Binding<ConjurSecretStringCredentials> {
    private static final Logger LOGGER = Logger.getLogger(ConjurSecretStringCredentialsBinding.class.getName());
    private static final String DISPLAY_NAME = "Secret String Credential";

    @DataBoundConstructor
    public ConjurSecretStringCredentialsBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    protected Class<ConjurSecretStringCredentials> type() {
        return ConjurSecretStringCredentials.class;
    }

    public Binding.SingleEnvironment bindSingle(@NonNull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        LOGGER.log(Level.FINEST, String.format("Bind ConjurSecretStringCredentials to %s", build.getDisplayName()));
        return new Binding.SingleEnvironment(((ConjurSecretStringCredentials)this.getCredentials(build)).getSecret().getPlainText());
    }

    @Symbol(value={"conjurSecretString"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<ConjurSecretStringCredentials> {
        public boolean requiresWorkspace() {
            return false;
        }

        protected Class<ConjurSecretStringCredentials> type() {
            return ConjurSecretStringCredentials.class;
        }

        public String getDisplayName() {
            return ConjurSecretStringCredentialsBinding.DISPLAY_NAME;
        }
    }
}

