/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.conjursecrets.ConjurSecretFileCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.lang.NonNull;

public class ConjurSecretFileCredentialsImpl
extends BaseStandardCredentials
implements ConjurSecretFileCredentials {
    private static final long serialVersionUID = 1L;
    private final String variableId;
    private transient ModelObject context;
    private transient ModelObject inheritedObjectContext;
    private boolean storedInConjurStorage = false;

    @DataBoundConstructor
    public ConjurSecretFileCredentialsImpl(CredentialsScope scope, String id, String description, String variableId) {
        super(scope, id, description);
        this.variableId = variableId;
    }

    @NonNull
    public String getFileName() {
        return "conjur-file";
    }

    @NonNull
    public InputStream getContent() throws IOException {
        Secret secret = this.getSecret();
        if (secret == null) {
            throw new IOException("Can't retrieve secret for variableId: " + this.variableId);
        }
        return new ByteArrayInputStream(secret.getPlainText().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Secret getSecret() {
        Secret retSecret = null;
        retSecret = this.storedInConjurStorage ? ConjurAPI.getSecretFromConjur(this.context, this.inheritedObjectContext, this.variableId) : ConjurAPI.getSecretFromConjurWithInheritance(this.context, this, this.variableId);
        return retSecret;
    }

    @Override
    public String getDisplayName() {
        return "ConjurSecretFile:" + this.variableId;
    }

    @Override
    public String getNameTag() {
        return "";
    }

    @Override
    public void setContext(ModelObject context) {
        this.context = context;
    }

    @Override
    public ModelObject getContext() {
        return this.context;
    }

    @Override
    public void setInheritedContext(ModelObject context) {
        this.inheritedObjectContext = context;
    }

    @Override
    public ModelObject getInheritedContext() {
        return this.inheritedObjectContext;
    }

    @Override
    public void setStoredInConjurStorage(boolean storedInConjurStorage) {
        this.storedInConjurStorage = storedInConjurStorage;
    }

    @Override
    public boolean storedInConjurStorage() {
        return this.storedInConjurStorage;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Conjur Secret File";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="variableId") String variableId) {
            if (variableId == null || variableId.isEmpty()) {
                return FormValidation.error((String)"FAILED variableId field is required");
            }
            ConjurSecretFileCredentialsImpl credential = new ConjurSecretFileCredentialsImpl(CredentialsScope.GLOBAL, "test", "desc", variableId);
            return ConjurAPIUtils.validateCredential(context, credential);
        }
    }
}

