/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.handlers;

import com.google.common.cache.LoadingCache;
import org.easymock.EasyMock;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.Payloads;
import org.jclouds.openstack.keystone.v1_1.handlers.RetryOnRenew;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RetryOnRenewTest")
public class RetryOnRenewTest {
    @Test
    public void test401ShouldRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        BackoffLimitedRetryHandler backoffHandler = (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request);
        cache.invalidateAll();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)Payloads.newStringPayload((String)"token expired, please renew")).anyTimes();
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)401).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{command});
        EasyMock.replay((Object[])new Object[]{response});
        EasyMock.replay((Object[])new Object[]{cache});
        EasyMock.replay((Object[])new Object[]{backoffHandler});
        RetryOnRenew retry = new RetryOnRenew(cache, backoffHandler);
        Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{cache});
        EasyMock.verify((Object[])new Object[]{backoffHandler});
    }

    @Test
    public void test401ShouldRetry4Times() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        BackoffLimitedRetryHandler backoffHandler = (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).anyTimes();
        EasyMock.expect((Object)request.getHeaders()).andStubReturn(null);
        cache.invalidateAll();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)Payloads.newStringPayload((String)"")).anyTimes();
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)401).anyTimes();
        EasyMock.replay((Object[])new Object[]{command, request, response, cache});
        RetryOnRenew retry = new RetryOnRenew(cache, backoffHandler);
        for (int i = 0; i < RetryOnRenew.NUM_RETRIES - 1; ++i) {
            Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response), (String)"Expected retry to succeed");
        }
        Assert.assertFalse((boolean)retry.shouldRetryRequest(command, response), (String)("Expected retry to fail on attempt " + RetryOnRenew.NUM_RETRIES));
        EasyMock.verify((Object[])new Object[]{command, response, cache});
    }

    @Test
    public void test408ShouldRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        BackoffLimitedRetryHandler backoffHandler = (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class);
        EasyMock.expect((Object)backoffHandler.shouldRetryRequest(command, response)).andReturn((Object)true).once();
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)408).once();
        EasyMock.replay((Object[])new Object[]{command});
        EasyMock.replay((Object[])new Object[]{response});
        EasyMock.replay((Object[])new Object[]{cache});
        EasyMock.replay((Object[])new Object[]{backoffHandler});
        RetryOnRenew retry = new RetryOnRenew(cache, backoffHandler);
        Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{cache});
        EasyMock.verify((Object[])new Object[]{backoffHandler});
    }

    @Test
    public void test404ShouldNotRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        BackoffLimitedRetryHandler backoffHandler = (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)404).once();
        EasyMock.replay((Object[])new Object[]{command});
        EasyMock.replay((Object[])new Object[]{response});
        EasyMock.replay((Object[])new Object[]{cache});
        EasyMock.replay((Object[])new Object[]{backoffHandler});
        RetryOnRenew retry = new RetryOnRenew(cache, backoffHandler);
        Assert.assertTrue((!retry.shouldRetryRequest(command, response) ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{command});
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{cache});
        EasyMock.verify((Object[])new Object[]{backoffHandler});
    }
}

