/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.functions;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.domain.AuthenticationResponse;
import org.jclouds.openstack.functions.ParseAuthenticationResponseFromHeaders;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseAuthenticationResponseFromHeadersTest")
public class ParseAuthenticationResponseFromHeadersTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.api-version")).to("1");
        }
    }});

    public void testReplaceLocalhost() {
        ParseAuthenticationResponseFromHeaders parser = (ParseAuthenticationResponseFromHeaders)this.i.getInstance(ParseAuthenticationResponseFromHeaders.class);
        parser = parser.setHostToReplace("fooman");
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(204).message("No Content").addHeader("X-Auth-Token", new String[]{"token"})).addHeader("X-Storage-Token", new String[]{"token"})).addHeader("X-Storage-Url", new String[]{"http://127.0.0.1:8080/v1/token"})).addHeader("X-CDN-Management-Url", new String[]{"http://127.0.0.1:8080/cdn-mgmt"})).addHeader("X-Server-Management-Url", new String[]{"http://127.0.0.1:8080/srv-mgmt"})).build();
        AuthenticationResponse md = parser.apply(response);
        Assert.assertEquals((String)md.getAuthToken(), (String)"token");
        Assert.assertEquals(md.getServices().get("X-Storage-Url"), (Object)URI.create("http://fooman:8080/v1/token"));
        Assert.assertEquals(md.getServices().get("X-CDN-Management-Url"), (Object)URI.create("http://fooman:8080/cdn-mgmt"));
        Assert.assertEquals(md.getServices().get("X-Server-Management-Url"), (Object)URI.create("http://fooman:8080/srv-mgmt"));
    }

    public void testHandleHeadersCaseInsensitively() {
        ParseAuthenticationResponseFromHeaders parser = (ParseAuthenticationResponseFromHeaders)this.i.getInstance(ParseAuthenticationResponseFromHeaders.class);
        parser = parser.setHostToReplace("fooman");
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(204).message("No Content").addHeader("x-auth-token", new String[]{"token"})).addHeader("x-storage-token", new String[]{"token"})).addHeader("x-storage-url", new String[]{"http://127.0.0.1:8080/v1/token"})).addHeader("x-cdn-management-url", new String[]{"http://127.0.0.1:8080/cdn-mgmt"})).addHeader("x-server-management-url", new String[]{"http://127.0.0.1:8080/srv-mgmt"})).build();
        AuthenticationResponse md = parser.apply(response);
        Assert.assertEquals((String)md.getAuthToken(), (String)"token");
        Assert.assertEquals(md.getServices().get("X-Storage-Url"), (Object)URI.create("http://fooman:8080/v1/token"));
        Assert.assertEquals(md.getServices().get("X-CDN-Management-Url"), (Object)URI.create("http://fooman:8080/cdn-mgmt"));
        Assert.assertEquals(md.getServices().get("X-Server-Management-Url"), (Object)URI.create("http://fooman:8080/srv-mgmt"));
    }
}

