/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * OWASP Enterprise Security API (ESAPI)
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * Enterprise Security API (ESAPI) project. For details, please see
 * <a href="http://www.owasp.org/index.php/ESAPI">http://www.owasp.org/index.php/ESAPI</a>.
 *
 * Copyright (c) 2007 - The OWASP Foundation
 * 
 * The ESAPI is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Jeff Williams <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @created 2007
 */

package net.shibboleth.utilities.java.support.codec;

import javax.annotation.Nullable;

import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Legacy version of {@link net.shibboleth.shared.codec.HTMLEncoder}.
 * 
 * @deprecated
 */
@Deprecated(since="9.0.0", forRemoval=true)
public final class HTMLEncoder {

    /** Constructor. */
    private HTMLEncoder() {

    }

    /**
     * Encode data for use in HTML using HTML entity encoding
     * <p>
     * Note that the following characters: 00-08, 0B-0C, 0E-1F, and 7F-9F
     * <p>
     * cannot be used in HTML.
     * 
     * @see <a href="http://en.wikipedia.org/wiki/Character_encodings_in_HTML">HTML Encodings [wikipedia.org]</a>
     * @see <a href="http://www.w3.org/TR/html4/sgml/sgmldecl.html">SGML Specification [w3.org]</a>
     * @see <a href="http://www.w3.org/TR/REC-xml/#charsets">XML Specification [w3.org]</a>
     * 
     * @param input the text to encode for HTML
     * 
     * @return input encoded for HTML
     */
    @Nullable public static String encodeForHTML(@Nullable final String input) {
        DeprecationSupport.warn(ObjectType.CLASS, HTMLEncoder.class.getName(), null,
                net.shibboleth.shared.codec.HTMLEncoder.class.getName());
        
        return net.shibboleth.shared.codec.HTMLEncoder.encodeForHTML(input);
    }

    /**
     * Encode data for use in HTML attributes.
     * 
     * @param input the text to encode for an HTML attribute
     * 
     * @return input encoded for use as an HTML attribute
     */
    @Nullable public static String encodeForHTMLAttribute(@Nullable final String input) {
        DeprecationSupport.warn(ObjectType.CLASS, HTMLEncoder.class.getName(), null,
                net.shibboleth.shared.codec.HTMLEncoder.class.getName());

        if (input == null) {
            return null;
        }
        return net.shibboleth.shared.codec.HTMLEncoder.encodeForHTMLAttribute(input);
    }

}