/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.primitive;

import java.lang.reflect.Method;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Utility functions related to reflection.
 * 
 * @since 9.2.0
 */
public final class ReflectionSupport {

    /**
     * Gets a method via reflection with a given name and parameter types on a class.
     * 
     * @param claz class of object
     * @param methodName name of method
     * @param parameterTypes types of parameters, if any
     * 
     * @return the matching {@link Method} or null
     */
    @Nullable public static Method getMethod(@Nonnull final Class<?> claz, @Nonnull final String methodName,
            @Nullable final Class<?>... parameterTypes) {
        try {
            // Attempt to get the method
            return claz.getMethod(methodName, parameterTypes);
        } catch (final NoSuchMethodException|SecurityException e) {
        }
        
        return null;
    }

    
    /** Private constructor. */
    private ReflectionSupport() {
        
    }
}