/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.relyingparty;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;

public class BasicRelyingPartyConfiguration
extends AbstractIdentifiableInitializableComponent
implements RelyingPartyConfiguration,
Predicate<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> detailedErrorsPredicate;
    @Nonnull
    private Function<ProfileRequestContext, SecurityConfiguration> securityConfigurationLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Map<String, ProfileConfiguration>> profileConfigurationsLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();

    public BasicRelyingPartyConfiguration() {
        this.issuerLookupStrategy = FunctionSupport.constant(null);
        this.detailedErrorsPredicate = PredicateSupport.alwaysFalse();
        this.securityConfigurationLookupStrategy = FunctionSupport.constant(null);
        this.profileConfigurationsLookupStrategy = FunctionSupport.constant(null);
    }

    @Override
    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Deprecated(since="5.0.0", forRemoval=true)
    public void setResponderId(@Nullable @NotEmpty String issuer) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setResponderId", (String)"relying-party.xml", (String)"setIssuer");
        this.setIssuer(issuer);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setResponderIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setResponderIdLookupStrategy", (String)"relying-party.xml", (String)"setIssuerLookupStrategy");
        this.setIssuerLookupStrategy(strategy);
    }

    @Override
    public boolean isDetailedErrors(@Nullable ProfileRequestContext profileRequestContext) {
        return this.detailedErrorsPredicate.test(profileRequestContext);
    }

    public void setDetailedErrors(boolean flag) {
        this.checkSetterPreconditions();
        this.detailedErrorsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setDetailedErrorsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.detailedErrorsPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Override
    @Nullable
    public SecurityConfiguration getSecurityConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return this.securityConfigurationLookupStrategy.apply(profileRequestContext);
    }

    public void setSecurityConfiguration(@Nullable SecurityConfiguration configuration) {
        this.securityConfigurationLookupStrategy = FunctionSupport.constant((Object)configuration);
    }

    public void setSecurityConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityConfiguration> strategy) {
        this.securityConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, ProfileConfiguration> getProfileConfigurations(@Nullable ProfileRequestContext profileRequestContext) {
        Map<String, ProfileConfiguration> map = this.profileConfigurationsLookupStrategy.apply(profileRequestContext);
        if (map != null) {
            return CollectionSupport.copyToMap(map);
        }
        return CollectionSupport.emptyMap();
    }

    @Override
    @Nullable
    public ProfileConfiguration getProfileConfiguration(@Nullable ProfileRequestContext profileRequestContext, @Nullable String profileId) {
        String trimmedId = StringSupport.trimOrNull((String)profileId);
        if (trimmedId == null) {
            return null;
        }
        return this.getProfileConfigurations(profileRequestContext).get(trimmedId);
    }

    public void setProfileConfigurations(@Nullable Collection<ProfileConfiguration> configs) {
        this.checkSetterPreconditions();
        if (configs == null) {
            this.profileConfigurationsLookupStrategy = FunctionSupport.constant(null);
        } else {
            HashMap<String, ProfileConfiguration> map = new HashMap<String, ProfileConfiguration>();
            for (ProfileConfiguration config : configs) {
                String trimmedId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)config.getId()), (String)("ID of profile configuration class " + config.getClass().getName() + " cannot be null"));
                map.put(trimmedId, config);
            }
            this.profileConfigurationsLookupStrategy = FunctionSupport.constant(map);
        }
    }

    public void setProfileConfigurationsLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, ProfileConfiguration>> strategy) {
        this.checkSetterPreconditions();
        this.profileConfigurationsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Relying party configuration activation condition cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        this.checkComponentActive();
        return this.activationCondition.test(input);
    }
}

