/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.plugin.AbstractPlugin;
import net.shibboleth.profile.plugin.Plugin;
import net.shibboleth.profile.plugin.PluginException;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public abstract class PropertyDrivenPlugin<T extends Module>
extends AbstractPlugin<T>
implements Plugin<T> {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_RESOURCE = "plugin.properties";
    @Nonnull
    @NotEmpty
    public static final String PLUGIN_ID_PROPERTY = "plugin.id";
    @Nonnull
    @NotEmpty
    public static final String PLUGIN_VERSION_PROPERTY = "plugin.version";
    @Nonnull
    @NotEmpty
    public static final String PLUGIN_LICENSE_PROPERTY = "plugin.license";
    @Nonnull
    @NotEmpty
    public static final String PLUGIN_URL_PROPERTY = "plugin.url.";
    @Nonnull
    @NotEmpty
    public static final String PLUGIN_REQ_MODULES_PROPERTY = "plugin.modules.required";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PropertyDrivenPlugin.class);
    @Nonnull
    private final Properties pluginProperties;
    @Nullable
    private String pluginId;
    @Nullable
    private InstallableComponentVersion pluginVersion;
    @Nonnull
    private List<URL> updateURLs = CollectionSupport.emptyList();
    @Nonnull
    private Set<String> requiredModules = CollectionSupport.emptySet();

    public PropertyDrivenPlugin(@Nonnull Class<? extends Plugin<T>> claz) throws IOException, PluginException {
        this(claz.getResourceAsStream(DEFAULT_RESOURCE));
    }

    public PropertyDrivenPlugin(@Nonnull InputStream inputStream) throws IOException, PluginException {
        this.pluginProperties = new Properties();
        this.pluginProperties.load(inputStream);
        this.load();
    }

    public PropertyDrivenPlugin(@Nonnull Properties properties) throws PluginException {
        this.pluginProperties = (Properties)Constraint.isNotNull((Object)properties, (String)"Properties cannot be null");
        this.load();
    }

    protected void load() throws PluginException {
        String urlstr;
        this.pluginId = StringSupport.trimOrNull((String)this.pluginProperties.getProperty(PLUGIN_ID_PROPERTY));
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version == null) {
            version = StringSupport.trimOrNull((String)this.pluginProperties.getProperty(PLUGIN_VERSION_PROPERTY));
            if (version == null) {
                throw new PluginException("No plugin version property or package attribute available for " + this.pluginId);
            }
            this.log.debug("Using plugin '{}' version property in favor of absent package manifest", (Object)this.pluginId);
        }
        try {
            this.pluginVersion = new InstallableComponentVersion(version);
        }
        catch (NumberFormatException e) {
            throw new PluginException(e);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        Integer urlnum = 1;
        while ((urlstr = this.pluginProperties.getProperty(PLUGIN_URL_PROPERTY + urlnum.toString())) != null) {
            try {
                urls.add(new URL(urlstr));
            }
            catch (MalformedURLException e) {
                this.log.error("Unable to convert property value '{}' to URL", (Object)urlstr, (Object)e);
            }
            urlnum = urlnum + 1;
        }
        urls.addAll(this.getDefaultUpdateURLs());
        this.updateURLs = CollectionSupport.copyToList(urls);
        this.requiredModules = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection((Collection)StringSupport.stringToList((String)this.pluginProperties.getProperty(PLUGIN_REQ_MODULES_PROPERTY, ""), (String)",")));
        this.log.debug("Plugin {} loaded", (Object)this.getPluginId());
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getPluginId() {
        if (this.pluginId != null) {
            return this.pluginId;
        }
        return super.getPluginId();
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<URL> getUpdateURLs() {
        return this.updateURLs;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getRequiredModules() {
        return this.requiredModules;
    }

    @Override
    @Nullable
    public String getLicenseFileLocation() {
        return this.pluginProperties.getProperty(PLUGIN_LICENSE_PROPERTY);
    }

    @Override
    @NonNegative
    public int getMajorVersion() {
        assert (this.pluginVersion != null);
        return this.pluginVersion.getMajor();
    }

    @Override
    @NonNegative
    public int getMinorVersion() {
        assert (this.pluginVersion != null);
        return this.pluginVersion.getMinor();
    }

    @Override
    @NonNegative
    public int getPatchVersion() {
        assert (this.pluginVersion != null);
        return this.pluginVersion.getPatch();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<URL> getDefaultUpdateURLs() throws PluginException {
        return CollectionSupport.emptyList();
    }
}

