/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.profile.context.logic.AbstractAttributePredicate;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class RegexAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegexAttributePredicate.class);
    @Nullable
    @NotEmpty
    private String attributeId;
    @Nullable
    private Pattern pattern;

    @Nullable
    @NotEmpty
    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(@Nonnull @NotEmpty String id) {
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Attribute ID cannot be null or empty");
    }

    @Nullable
    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(@Nonnull Pattern p) {
        this.pattern = p;
    }

    public void setPattern(@Nonnull @NotEmpty String s) {
        this.pattern = Pattern.compile(s);
    }

    @Override
    protected boolean hasMatch(@Nonnull Map<String, IdPAttribute> attributeMap) {
        if (this.attributeId == null || this.pattern == null) {
            this.log.warn("Attribute ID or regular expression were not set");
            return false;
        }
        IdPAttribute attribute = attributeMap.get(this.attributeId);
        if (attribute == null) {
            this.log.debug("Attribute '{}' not found in context", (Object)this.attributeId);
            return false;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue)) continue;
            assert (this.pattern != null);
            Matcher m = this.pattern.matcher(((StringAttributeValue)value).getValue());
            if (!m.matches()) continue;
            this.log.debug("Found matching value '{}' in attribute '{}'", (Object)m.group(), (Object)this.attributeId);
            return true;
        }
        this.log.debug("Attribute '{}' values not matched", (Object)this.attributeId);
        return false;
    }
}

