/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.config.navigate.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.messaging.AbstractDefaultSecurityConfigurationLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.config.XMLSecurityConfiguration;

public class SignatureSigningConfigurationLookupFunction
extends AbstractDefaultSecurityConfigurationLookupFunction<List<SignatureSigningConfiguration>> {
    @Nullable
    @Live
    public List<SignatureSigningConfiguration> apply(@Nullable MessageContext input) {
        ArrayList<SignatureSigningConfiguration> configs = new ArrayList<SignatureSigningConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContext(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            XMLSecurityConfiguration xsc;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(this.getProfileRequestContext(input))) instanceof XMLSecurityConfiguration && (xsc = (XMLSecurityConfiguration)sc).getSignatureSigningConfiguration() != null) {
                configs.add(xsc.getSignatureSigningConfiguration());
            }
            if ((defaultConfig = this.getDefaultSecurityConfiguration(rpc.getConfiguration(), input)) instanceof XMLSecurityConfiguration && (xsc = (XMLSecurityConfiguration)defaultConfig).getSignatureSigningConfiguration() != null) {
                configs.add(xsc.getSignatureSigningConfiguration());
            }
        }
        configs.add(SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
        return configs;
    }
}

