/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.config;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;

public abstract class AbstractProfileConfiguration
extends AbstractIdentifiableInitializableComponent
implements ProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, SecurityConfiguration> securityConfigurationLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> disallowedFeaturesLookupStrategy;

    public AbstractProfileConfiguration(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        this.setId(id);
        this.securityConfigurationLookupStrategy = FunctionSupport.constant(null);
        this.disallowedFeaturesLookupStrategy = FunctionSupport.constant((Object)DEFAULT_DISALLOWED_FEATURES);
    }

    @Override
    @Nullable
    public SecurityConfiguration getSecurityConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return this.securityConfigurationLookupStrategy.apply(profileRequestContext);
    }

    public void setSecurityConfiguration(@Nullable SecurityConfiguration configuration) {
        this.securityConfigurationLookupStrategy = FunctionSupport.constant((Object)configuration);
    }

    public void setSecurityConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityConfiguration> strategy) {
        this.securityConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    public boolean isFeatureDisallowed(@Nullable ProfileRequestContext profileRequestContext, int feature) {
        return (this.getDisallowedFeatures(profileRequestContext) & feature) == feature;
    }

    @Override
    public int getDisallowedFeatures(@Nullable ProfileRequestContext profileRequestContext) {
        Integer mask = this.disallowedFeaturesLookupStrategy.apply(profileRequestContext);
        return mask != null ? mask : DEFAULT_DISALLOWED_FEATURES;
    }

    public void setDisallowedFeatures(int mask) {
        this.disallowedFeaturesLookupStrategy = FunctionSupport.constant((Object)mask);
    }

    public void setDisallowedFeaturesLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.disallowedFeaturesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProfileConfiguration)) {
            return false;
        }
        AbstractProfileConfiguration other = (AbstractProfileConfiguration)obj;
        return Objects.equals(this.getId(), other.getId());
    }
}

