/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet.impl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;

public class BasicHttpServletRequestMethodValidator
extends AbstractInitializableComponent
implements HttpServletRequestValidator {
    @Nonnull
    private Set<String> allowedMethods = CollectionSupport.emptySet();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(@Nullable Collection<String> methods) {
        this.checkSetterPreconditions();
        this.allowedMethods = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(methods));
    }

    @Override
    public void validate(@Nonnull HttpServletRequest request) throws ServletException {
        Constraint.isNotNull((Object)request, (String)"HttpServletRequest was null");
        if (!this.allowedMethods.contains(request.getMethod())) {
            throw new ServletException("Request method '" + request.getMethod() + "' not in allowed set.");
        }
    }
}

