/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyList;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;

public final class URISupport {
    private URISupport() {
    }

    @Nonnull
    public static URI setFragment(@Nonnull URI prototype, @Nullable String fragment) {
        try {
            return new URI(prototype.getScheme(), prototype.getUserInfo(), prototype.getHost(), prototype.getPort(), prototype.getPath(), prototype.getQuery(), URISupport.trimOrNullFragment(fragment));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal fragment text", e);
        }
    }

    @Nonnull
    public static URI setHost(@Nonnull URI prototype, @Nullable String host) {
        try {
            return new URI(prototype.getScheme(), prototype.getUserInfo(), StringSupport.trimOrNull((String)host), prototype.getPort(), prototype.getPath(), prototype.getQuery(), prototype.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal host", e);
        }
    }

    @Nonnull
    public static URI setPath(@Nonnull URI prototype, @Nullable String path) {
        try {
            return new URI(prototype.getScheme(), prototype.getUserInfo(), prototype.getHost(), prototype.getPort(), URISupport.trimOrNullPath(path), prototype.getQuery(), prototype.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal path", e);
        }
    }

    @Nonnull
    public static URI setPort(@Nonnull URI prototype, int port) {
        try {
            return new URI(prototype.getScheme(), prototype.getUserInfo(), prototype.getHost(), port, prototype.getPath(), prototype.getQuery(), prototype.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal port", e);
        }
    }

    @Nonnull
    public static URI setQuery(@Nonnull URI prototype, @Nullable String query) {
        try {
            return new URI(prototype.getScheme(), prototype.getUserInfo(), prototype.getHost(), prototype.getPort(), prototype.getPath(), URISupport.trimOrNullQuery(query), prototype.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal query", e);
        }
    }

    @Nonnull
    public static URI setQuery(@Nonnull URI prototype, @Nullable List<Pair<String, String>> parameters) {
        try {
            return new URI(prototype.getScheme(), prototype.getUserInfo(), prototype.getHost(), prototype.getPort(), prototype.getPath(), URISupport.buildQuery(parameters), prototype.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal query", e);
        }
    }

    @Nonnull
    public static URI setScheme(@Nonnull URI prototype, @Nullable String scheme) {
        try {
            return new URI(StringSupport.trimOrNull((String)scheme), prototype.getUserInfo(), prototype.getHost(), prototype.getPort(), prototype.getPath(), prototype.getQuery(), prototype.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal scheme", e);
        }
    }

    @Nonnull
    public static URI fileURIFromAbsolutePath(@Nonnull String path) throws URISyntaxException {
        StringBuilder uriPath = new StringBuilder(path.length() + 8);
        uriPath.append("file://");
        if (!path.startsWith("/")) {
            uriPath.append('/');
        }
        uriPath.append(path);
        return new URI(uriPath.toString());
    }

    @Nullable
    public static String buildQuery(@Nullable List<Pair<String, String>> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean firstParam = true;
        for (Pair<String, String> parameter : parameters) {
            if (firstParam) {
                firstParam = false;
            } else {
                builder.append("&");
            }
            builder.append(URISupport.doURLEncode((String)parameter.getFirst()));
            builder.append("=");
            if (parameter.getSecond() == null) continue;
            builder.append(URISupport.doURLEncode((String)parameter.getSecond()));
        }
        return builder.toString();
    }

    @Nonnull
    @NullableElements
    @Unmodifiable
    @NotLive
    public static Map<String, String> buildQueryMap(@Nullable @NullableElements List<Pair<String, String>> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return CollectionSupport.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Pair<String, String> param : parameters) {
            if (param.getFirst() == null) continue;
            map.put((String)param.getFirst(), (String)param.getSecond());
        }
        return CollectionSupport.copyToMap(map);
    }

    @Nonnull
    @NullableElements
    @Unmodifiable
    @NotLive
    public static Map<String, List<String>> buildQueryMultiMap(@Nullable @NullableElements List<Pair<String, String>> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return CollectionSupport.emptyMap();
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (Pair<String, String> param : parameters) {
            if (param.getFirst() == null) continue;
            ArrayList<String> currentValue = (ArrayList<String>)map.get(param.getFirst());
            if (currentValue == null) {
                currentValue = new ArrayList<String>();
                map.put((String)param.getFirst(), currentValue);
            }
            currentValue.add((String)param.getSecond());
        }
        return CollectionSupport.copyToMap(map);
    }

    @Nullable
    public static String getRawQueryStringParameter(@Nullable String queryString, @Nullable String paramName) {
        String[] candidates;
        String trimmedQuery = URISupport.trimOrNullQuery(queryString);
        String trimmedName = StringSupport.trimOrNull((String)paramName);
        if (trimmedQuery == null || trimmedName == null) {
            return null;
        }
        String encodedName = URISupport.doURLEncode(trimmedName);
        for (String candidate : candidates = trimmedQuery.split("&")) {
            if (!candidate.startsWith(encodedName + "=") && !candidate.equals(encodedName)) continue;
            return candidate;
        }
        return null;
    }

    @Nonnull
    @Live
    public static List<Pair<String, String>> getRawQueryStringParameters(@Nullable String queryString, @Nullable String paramName) {
        String paramNameTrimmed = StringSupport.trimOrNull((String)paramName);
        if (paramNameTrimmed == null) {
            return CollectionSupport.emptyList();
        }
        return (List)((NonnullSupplier)URISupport.parseQueryString(queryString, false, false).stream().filter(p -> Objects.equals(URISupport.doURLDecode(paramNameTrimmed), URISupport.doURLDecode((String)p.getFirst()))).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }

    @Nonnull
    @Live
    public static List<Pair<String, String>> parseQueryString(@Nullable String queryString) {
        return URISupport.parseQueryString(queryString, true, true);
    }

    @Nonnull
    @Live
    public static List<Pair<String, String>> parseQueryString(@Nullable String queryString, boolean decodeName, boolean decodeValue, @Nonnull Charset charset) {
        String[] paramPairs;
        String trimmedQuery = URISupport.trimOrNullQuery(queryString);
        if (trimmedQuery == null) {
            return new LazyList();
        }
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        for (String paramPair : paramPairs = trimmedQuery.split("&")) {
            String[] param = paramPair.split("=");
            if (param.length == 1) {
                queryParams.add((Pair<String, String>)new Pair((Object)(decodeName ? URISupport.doURLDecode(param[0], charset) : param[0]), (Object)null));
                continue;
            }
            queryParams.add((Pair<String, String>)new Pair((Object)(decodeName ? URISupport.doURLDecode(param[0]) : param[0]), (Object)(decodeValue ? URISupport.doURLDecode(param[1], charset) : param[1])));
        }
        return queryParams;
    }

    @Nonnull
    @Live
    public static List<Pair<String, String>> parseQueryString(@Nullable String queryString, boolean decodeName, boolean decodeValue) {
        return URISupport.parseQueryString(queryString, decodeName, decodeValue, StandardCharsets.UTF_8);
    }

    @Nullable
    public static String trimOrNullPath(@Nullable String path) {
        String trimmedPath = StringSupport.trimOrNull((String)path);
        if (trimmedPath == null) {
            return null;
        }
        if (trimmedPath.startsWith("?")) {
            trimmedPath = trimmedPath.substring(1);
        }
        if (trimmedPath.endsWith("?") || trimmedPath.endsWith("#")) {
            trimmedPath = trimmedPath.substring(0, trimmedPath.length() - 1);
        }
        return trimmedPath;
    }

    @Nullable
    public static String trimOrNullQuery(@Nullable String query) {
        String trimmedQuery = StringSupport.trimOrNull((String)query);
        if (trimmedQuery == null) {
            return null;
        }
        if (trimmedQuery.startsWith("?")) {
            trimmedQuery = trimmedQuery.substring(1);
        }
        if (trimmedQuery.endsWith("#")) {
            trimmedQuery = trimmedQuery.substring(0, trimmedQuery.length() - 1);
        }
        return trimmedQuery;
    }

    @Nullable
    public static String trimOrNullFragment(@Nullable String fragment) {
        String trimmedFragment = StringSupport.trimOrNull((String)fragment);
        if (trimmedFragment == null) {
            return null;
        }
        if (trimmedFragment.startsWith("#")) {
            trimmedFragment = trimmedFragment.substring(1);
        }
        return trimmedFragment;
    }

    @Nullable
    public static String doURLDecode(@Nullable String value, @Nonnull Charset charset) {
        if (value == null) {
            return null;
        }
        return URLDecoder.decode(value, charset);
    }

    @Nullable
    public static String doURLDecode(@Nullable String value) {
        return URISupport.doURLDecode(value, StandardCharsets.UTF_8);
    }

    @Deprecated
    @Nullable
    public static String doURLEncode(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }
}

