/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.net.impl;

import java.util.function.Function;

import javax.annotation.Nullable;

import com.google.common.net.MediaType;

/**
 * Simple function to strip the parameters from a {@link MediaType}.
 */
public class StripMediaTypeParametersFunction implements Function<MediaType, MediaType> {

    /** {@inheritDoc} */
    @Nullable public MediaType apply(@Nullable final MediaType input) {
        return input != null ? input.withoutParameters() : null;
    }

}