/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.totp.context.TOTPContext;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public abstract class AbstractSeedSource
extends AbstractInitializableComponent
implements Consumer<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, TOTPContext> totpContextLookupStrategy = FunctionSupport.compose((Function)new ChildContextLookup(TOTPContext.class), (Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Encoding encoding = Encoding.BASE32;

    @Nonnull
    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@Nonnull Encoding enc) {
        this.checkSetterPreconditions();
        this.encoding = (Encoding)((Object)Constraint.isNotNull((Object)((Object)enc), (String)"Encoding cannot be null"));
    }

    @Nonnull
    public Function<ProfileRequestContext, TOTPContext> getTOTPContextLookupStrategy() {
        return this.totpContextLookupStrategy;
    }

    public void setTOTPContextLookupStrategy(@Nonnull Function<ProfileRequestContext, TOTPContext> strategy) {
        this.checkSetterPreconditions();
        this.totpContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public static enum Encoding {
        BASE64,
        BASE32;

    }
}

