/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base32Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class TOTPAuthenticatorArguments
extends AbstractIdPHomeAwareCommandLineArguments {
    @Parameter(names={"--authenticator"})
    @Nullable
    private String authenticatorName;
    @Parameter(names={"--issuer"})
    @Nullable
    private String issuer;
    @Parameter(names={"--account"})
    @Nullable
    private String account;
    @Nullable
    private byte[] seed;
    @Nullable
    private Integer tokenCode;
    @Nullable
    private Logger log;

    @Nonnull
    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(TOTPAuthenticatorArguments.class);
        }
        return this.log;
    }

    @Nullable
    @NotEmpty
    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    @Nullable
    @NotEmpty
    public byte[] getSeed() {
        return this.seed;
    }

    @Nullable
    @NotEmpty
    public String getIssuer() {
        return StringSupport.trimOrNull((String)this.issuer);
    }

    @Nullable
    @NotEmpty
    public String getAccountName() {
        return StringSupport.trimOrNull((String)this.account);
    }

    @Nullable
    public Integer getTokenCode() {
        return this.tokenCode;
    }

    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.getOtherArgs().size() == 3) {
            try {
                this.seed = Base32Support.decode((String)((String)this.getOtherArgs().get(1)));
            }
            catch (DecodingException e) {
                throw new IllegalArgumentException(e);
            }
            this.tokenCode = Integer.valueOf((String)this.getOtherArgs().get(2));
        } else if (this.getOtherArgs().size() != 1) {
            throw new IllegalArgumentException("Invalid operation requested, must have zero or two additional arguments");
        }
    }

    public void printHelp(PrintStream out) {
        out.println("TOTPAuthenticatorCLI");
        out.println("Provides a command line interface for TOTPAuthenticator operations.");
        out.println();
        out.println("   TOTPAuthenticatorCLI [options] springConfiguration [seed] [tokencode]");
        out.println();
        out.println("      springConfiguration      name of Spring configuration resource to use");
        out.println("      seed                     encoded seed (omit when generating a new credential)");
        out.println("      tokencode                token code to validate (omit when generating a new credential)");
        super.printHelp(out);
        out.println();
        out.println(String.format("  --%-20s %s", "authenticator", "Specifies a non-default TOTPAuthenticator bean to use."));
        out.println(String.format("  --%-20s %s", "issuer", "Specifies a token issuer when generating a new credential."));
        out.println(String.format("  --%-20s %s", "account", "Specifies a token account name when generating a new credential."));
        out.println();
    }
}

