/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.cli.AbstractCommandLineArguments;
import net.shibboleth.idp.cli.DataSealerArguments;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base32Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOTPAuthenticatorArguments
extends AbstractCommandLineArguments {
    @Parameter(names={"--authenticator"})
    @Nullable
    private String authenticatorName;
    @Parameter(names={"--issuer"})
    @Nullable
    private String issuer;
    @Parameter(names={"--account"})
    @Nullable
    private String account;
    @Nullable
    private byte[] seed;
    @Nullable
    private Integer tokenCode;
    @Nullable
    private Logger log;

    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(DataSealerArguments.class);
        }
        return this.log;
    }

    @Nullable
    @NotEmpty
    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    @Nullable
    @NotEmpty
    public byte[] getSeed() {
        return this.seed;
    }

    @Nullable
    @NotEmpty
    public String getIssuer() {
        return StringSupport.trimOrNull((String)this.issuer);
    }

    @Nullable
    @NotEmpty
    public String getAccountName() {
        return StringSupport.trimOrNull((String)this.account);
    }

    @Nullable
    public Integer getTokenCode() {
        return this.tokenCode;
    }

    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.getOtherArgs().size() == 3) {
            try {
                this.seed = Base32Support.decode((String)((String)this.getOtherArgs().get(1)));
            }
            catch (DecodingException e) {
                throw new IllegalArgumentException(e);
            }
            this.tokenCode = Integer.valueOf((String)this.getOtherArgs().get(2));
        } else if (this.getOtherArgs().size() != 1) {
            throw new IllegalArgumentException("Invalid operation requested, must have zero or two additional arguments");
        }
    }

    public void printHelp(PrintStream out) {
        out.println("TOTPAuthenticatorCLI");
        out.println("Provides a command line interface for TOTPAuthenticator operations.");
        out.println();
        out.println("   TOTPAuthenticatorCLI [options] springConfiguration [seed] [tokencode]");
        out.println();
        out.println("      springConfiguration      name of Spring configuration resource to use");
        out.println("      seed                     encoded seed (omit when generating a new credential)");
        out.println("      tokencode                token code to validate (omit when generating a new credential)");
        super.printHelp(out);
        out.println();
        out.println(String.format("  --%-20s %s", "authenticator", "Specifies a non-default TOTPAuthenticator bean to use."));
        out.println(String.format("  --%-20s %s", "issuer", "Specifies a token issuer when generating a new credential."));
        out.println(String.format("  --%-20s %s", "account", "Specifies a token account name when generating a new credential."));
        out.println();
    }
}

