/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.totp.context.TOTPContext;
import net.shibboleth.idp.plugin.authn.totp.impl.AbstractSeedSource;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.codec.Base32Support;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class StaticSeedSource
extends AbstractSeedSource {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticSeedSource.class);
    @Nonnull
    @NonnullElements
    private Multimap<String, byte[]> tokenSeeds = LinkedListMultimap.create();

    public void setSeeds(@Nonnull @NonnullElements Map<String, Collection<String>> seeds) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(seeds, (String)"Seed map cannot be null");
        seeds.forEach((k, v) -> {
            String user = StringSupport.trimOrNull((String)k);
            if (user != null) {
                StringSupport.normalizeStringCollection((Collection)v).forEach(s -> {
                    try {
                        switch (this.getEncoding()) {
                            case BASE32: {
                                this.tokenSeeds.get((Object)user).add(Base32Support.decode((String)s));
                                break;
                            }
                            case BASE64: {
                                this.tokenSeeds.get((Object)user).add(Base64Support.decode((String)s));
                                break;
                            }
                            default: {
                                throw new DecodingException("Unknown encoding type");
                            }
                        }
                    }
                    catch (DecodingException e) {
                        this.log.error("Unable to decode seed value", (Throwable)e);
                    }
                });
            }
        });
    }

    @Override
    public void accept(@Nullable ProfileRequestContext input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        TOTPContext totp = this.getTOTPContextLookupStrategy().apply(input);
        if (totp != null) {
            if (totp.getUsername() != null) {
                totp.getTokenSeeds().addAll(this.tokenSeeds.get((Object)totp.getUsername()));
            } else {
                this.log.warn("TOTPContext did not contain a username");
            }
        } else {
            this.log.warn("Unable to locate TOTPContext");
        }
    }
}

