/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import com.google.common.net.UrlEscapers;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import java.security.GeneralSecurityException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.totp.impl.TOTPAuthenticator;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.codec.Base32Support;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class GoogleTOTPAuthenticator
extends AbstractInitializableComponent
implements TOTPAuthenticator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GoogleAuthenticator.class);
    @NonnullAfterInit
    private GoogleAuthenticatorConfig authconfig;
    @NonnullAfterInit
    private GoogleAuthenticator authenticator;

    public void setGoogleAuthenticatorConfig(@Nonnull GoogleAuthenticatorConfig config) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authconfig = (GoogleAuthenticatorConfig)Constraint.isNotNull((Object)config, (String)"GoogleAuthenticator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authconfig == null) {
            this.authconfig = new GoogleAuthenticatorConfig();
        }
        this.authenticator = new GoogleAuthenticator(this.authconfig);
    }

    @Override
    public TOTPAuthenticator.TOTPCredential createCredential(final @Nullable @NotEmpty String issuer, @Nullable @NotEmpty String accountName) throws GeneralSecurityException {
        final GoogleAuthenticatorKey cred = this.authenticator.createCredentials();
        final String trimmedIssuer = StringSupport.trimOrNull((String)issuer);
        final String trimmedName = StringSupport.trimOrNull((String)accountName);
        try {
            String encodedSecret;
            byte[] secret;
            switch (this.authconfig.getKeyRepresentation()) {
                case BASE32: {
                    secret = Base32Support.decode((String)cred.getKey());
                    encodedSecret = cred.getKey();
                    break;
                }
                case BASE64: {
                    secret = Base64Support.decode((String)cred.getKey());
                    encodedSecret = Base32Support.encode((byte[])secret, (boolean)false);
                    break;
                }
                default: {
                    throw new DecodingException("Unknown key representation type");
                }
            }
            return new TOTPAuthenticator.TOTPCredential(){

                @Override
                public byte[] getKey() {
                    return secret;
                }

                @Override
                public String getTOTPURL() {
                    Object label = trimmedName != null ? (trimmedIssuer != null ? trimmedIssuer + ":" + trimmedName : trimmedName) : null;
                    StringBuilder url = new StringBuilder();
                    url.append("otpauth://totp/").append(UrlEscapers.urlPathSegmentEscaper().escape((String)label)).append("?secret=").append(UrlEscapers.urlFormParameterEscaper().escape(encodedSecret));
                    if (trimmedIssuer != null) {
                        url.append("&issuer=").append(UrlEscapers.urlFormParameterEscaper().escape(issuer));
                    }
                    return url.toString();
                }

                @Override
                public Collection<Integer> getScratchCodes() {
                    return cred.getScratchCodes();
                }
            };
        }
        catch (DecodingException | EncodingException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    public boolean validate(@Nonnull @NotEmpty byte[] secret, int code) {
        String encodedSecret;
        try {
            switch (this.authconfig.getKeyRepresentation()) {
                case BASE32: {
                    encodedSecret = Base32Support.encode((byte[])secret, (boolean)false);
                    break;
                }
                case BASE64: {
                    encodedSecret = Base64Support.encode((byte[])secret, (boolean)false);
                    break;
                }
                default: {
                    throw new EncodingException("Unknown key representation type");
                }
            }
        }
        catch (EncodingException e) {
            return false;
        }
        return this.authenticator.authorize(encodedSecret, code);
    }
}

