/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.authn.totp.impl.AbstractTOTPExtractionAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractTOTPFromHeader
extends AbstractTOTPExtractionAction {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_HEADER_NAME = "X-Shibboleth-TOTP";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractTOTPFromHeader.class);
    @NonnullAfterInit
    @NotEmpty
    private String headerName = "X-Shibboleth-TOTP";

    public void setHeaderName(@Nonnull @NotEmpty String header) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.headerName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)header), (String)"Header name cannot be null or empty");
    }

    @Override
    @Nullable
    protected String extractCode(@Nonnull HttpServletRequest httpRequest) {
        return httpRequest.getHeader(this.headerName);
    }
}

