/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.plugin.authn.totp.context.TOTPContext;
import net.shibboleth.idp.plugin.authn.totp.impl.AbstractSeedSource;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.codec.Base32Support;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class AttributeResolverSeedSource
extends AbstractSeedSource {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_ATTRIBUTE_ID = "tokenSeeds";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverSeedSource.class);
    @NonnullAfterInit
    private ReloadableService<AttributeResolver> attributeResolver;
    @NonnullAfterInit
    @NotEmpty
    private String attributeId;

    public void setAttributeResolver(@Nonnull ReloadableService<AttributeResolver> service) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeResolver = (ReloadableService)Constraint.isNotNull(service, (String)"AttributeResolver cannot be null");
    }

    public void setSourceAttribute(@Nonnull @NotEmpty String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Source attribute ID cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeResolver == null) {
            throw new ComponentInitializationException("AttributeResolver cannot be null");
        }
        if (this.attributeId == null) {
            throw new ComponentInitializationException("Source attribute ID cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(@Nullable ProfileRequestContext input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        TOTPContext totp = this.getTOTPContextLookupStrategy().apply(input);
        if (totp != null && totp.getUsername() != null) {
            AttributeResolutionContext resCtx = (AttributeResolutionContext)totp.getSubcontext(AttributeResolutionContext.class, true);
            resCtx.setResolutionLabel("TOTP");
            resCtx.setPrincipal(totp.getUsername());
            resCtx.setRequestedIdPAttributeNames(Collections.singletonList(this.attributeId));
            this.log.debug("Resolving attribute {} for '{}'", (Object)this.attributeId, (Object)totp.getUsername());
            Collection<byte[]> seeds = totp.getTokenSeeds();
            try {
                resCtx.resolveAttributes(this.attributeResolver);
                IdPAttribute attribute = (IdPAttribute)resCtx.getResolvedIdPAttributes().get(this.attributeId);
                if (attribute != null) {
                    attribute.getValues().stream().filter(StringAttributeValue.class::isInstance).map(StringAttributeValue.class::cast).map(StringAttributeValue::getValue).forEachOrdered(v -> {
                        try {
                            switch (this.getEncoding()) {
                                case BASE32: {
                                    seeds.add(Base32Support.decode((String)v));
                                    break;
                                }
                                case BASE64: {
                                    seeds.add(Base64Support.decode((String)v));
                                    break;
                                }
                                default: {
                                    throw new DecodingException("Unknown encoding type");
                                }
                            }
                        }
                        catch (DecodingException e) {
                            this.log.error("Unable to decode seed", (Throwable)e);
                        }
                    });
                }
            }
            finally {
                totp.removeSubcontext((BaseContext)resCtx);
            }
            this.log.debug("Resolved {} seed(s) for '{}'", (Object)seeds.size(), (Object)totp.getUsername());
        } else {
            this.log.warn("Unable to locate TOTPContext with username set");
        }
    }
}

