/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.plugin.authn.totp.context.TOTPContext;
import net.shibboleth.idp.session.context.navigate.CanonicalUsernameLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTOTPExtractionAction
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractTOTPExtractionAction.class);
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = new CanonicalUsernameLookupStrategy();
    @Nonnull
    private Function<AuthenticationContext, TOTPContext> totpContextCreationStrategy = new ChildContextLookup(TOTPContext.class, true);
    @Nullable
    private TOTPContext totpContext;

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setTOTPContextCreationStrategy(@Nonnull Function<AuthenticationContext, TOTPContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.totpContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"TOTPContext creation strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        HttpServletRequest request;
        authenticationContext.removeSubcontext(AuthenticationErrorContext.class);
        this.totpContext = this.totpContextCreationStrategy.apply(authenticationContext);
        this.totpContext.setTokenCode(null);
        if (this.totpContext.getUsername() == null) {
            String username = this.usernameLookupStrategy.apply(profileRequestContext);
            if (username == null) {
                this.log.warn("{} No principal name available", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnknownUsername");
                return;
            }
            this.totpContext.setUsername(username);
        }
        if ((request = this.getHttpServletRequest()) == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        String code = this.extractCode(request);
        if (code == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        try {
            this.totpContext.setTokenCode(Integer.valueOf(code));
        }
        catch (NumberFormatException e) {
            this.log.warn("{} Exception converting code string to an integer", (Object)this.getLogPrefix(), (Object)e);
            ((AuthenticationErrorContext)authenticationContext.getSubcontext(AuthenticationErrorContext.class, true)).getClassifiedErrors().add("InvalidCredentials");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
        }
    }

    @Nullable
    protected abstract String extractCode(@Nonnull HttpServletRequest var1);
}

