/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.security.credential.Credential;

public final class TestTokenHelper {
    private TestTokenHelper() {
    }

    @Nonnull
    public static JWTClaimsSet createBasicClaims(Map<String, Object> overrideClaims) {
        return new JWTClaimsSet.Builder().issuer(TestTokenHelper.getClaimValue(overrideClaims, "iss", "test-issuer", String.class)).audience(TestTokenHelper.getClaimValue(overrideClaims, "aud", List.of("test-client"), List.class)).subject(TestTokenHelper.getClaimValue(overrideClaims, "sub", "jdoe", String.class)).claim("preferred_username", (Object)TestTokenHelper.getClaimValue(overrideClaims, "preferred_username", "d.tu", String.class)).claim("given_name", (Object)TestTokenHelper.getClaimValue(overrideClaims, "given_name", "Demo", String.class)).claim("family_name", (Object)TestTokenHelper.getClaimValue(overrideClaims, "family_name", "User", String.class)).claim("nonce", (Object)TestTokenHelper.getClaimValue(overrideClaims, "nonce", "abadnonce", String.class)).claim("nickname", (Object)TestTokenHelper.getClaimValue(overrideClaims, "nickname", "Dee", String.class)).claim("azp", (Object)TestTokenHelper.getClaimValue(overrideClaims, "azp", "test-client", String.class)).claim("name", (Object)TestTokenHelper.getClaimValue(overrideClaims, "name", "Demo T. User", String.class)).claim("acr", (Object)TestTokenHelper.getClaimValue(overrideClaims, "acr", "urn:mace:incommon:iap:silver", String.class)).claim("amr", (Object)TestTokenHelper.getClaimValue(overrideClaims, "amr", List.of("pwd", "otp"), List.class)).claim("auth_time", (Object)TestTokenHelper.getClaimValue(overrideClaims, "auth_time", new Date(), Date.class)).issueTime(TestTokenHelper.getClaimValue(overrideClaims, "iat", new Date(), Date.class)).expirationTime(TestTokenHelper.getClaimValue(overrideClaims, "auth_time", Date.from(Instant.now().plusSeconds(120L)), Date.class)).build();
    }

    @Nonnull
    public static JWTClaimsSet createBasicUserInfoClaims(Map<String, Object> overrideClaims) {
        return new JWTClaimsSet.Builder().issuer(TestTokenHelper.getClaimValue(overrideClaims, "iss", "test-issuer", String.class)).audience(TestTokenHelper.getClaimValue(overrideClaims, "aud", CollectionSupport.listOf((Object)"test-client"), List.class)).subject(TestTokenHelper.getClaimValue(overrideClaims, "sub", "jdoe", String.class)).claim("preferred_username", (Object)TestTokenHelper.getClaimValue(overrideClaims, "preferred_username", "d.tu", String.class)).claim("given_name", (Object)TestTokenHelper.getClaimValue(overrideClaims, "given_name", "Demo", String.class)).claim("family_name", (Object)TestTokenHelper.getClaimValue(overrideClaims, "family_name", "User", String.class)).claim("nickname", (Object)TestTokenHelper.getClaimValue(overrideClaims, "nickname", "Dee", String.class)).claim("name", (Object)TestTokenHelper.getClaimValue(overrideClaims, "name", "Demo T. User", String.class)).build();
    }

    private static <T> T getClaimValue(Map<String, Object> overrideClaims, String claimName, Object defaultValue, Class<T> type) {
        if (overrideClaims.containsKey(claimName)) {
            Object override = overrideClaims.get(claimName);
            if (override == null) {
                return null;
            }
            if (type.isInstance(override)) {
                if (override instanceof String && ((String)override).isEmpty()) {
                    return null;
                }
                return type.cast(override);
            }
        }
        return type.cast(defaultValue);
    }

    @Nonnull
    public static JWT createJWT(@Nonnull JWTClaimsSet payload, @Nullable JWSAlgorithm sigAlg, @Nullable JWEAlgorithm jweAlg, @Nullable EncryptionMethod enc, @Nullable Credential sigKey, @Nullable Credential encKey) throws JOSEException, ParseException {
        if (sigAlg != null && sigKey != null) {
            JWSHeader header = new JWSHeader.Builder(sigAlg).type(JOSEObjectType.JWT).build();
            SignedJWT signedJWT = new SignedJWT(header, payload);
            if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)sigAlg)) {
                signedJWT.sign((JWSSigner)new MACSigner(sigKey.getSecretKey()));
            } else if (JWSAlgorithm.Family.RSA.contains((Object)sigAlg)) {
                signedJWT.sign((JWSSigner)new RSASSASigner(sigKey.getPrivateKey()));
            } else if (JWSAlgorithm.Family.EC.contains((Object)sigAlg)) {
                signedJWT.sign((JWSSigner)new ECDSASigner((ECPrivateKey)sigKey.getPrivateKey()));
            }
            if (jweAlg != null && encKey != null) {
                JWEObject jweObject = new JWEObject(new JWEHeader.Builder(jweAlg, enc).contentType("JWT").build(), new Payload(signedJWT));
                if (JWEAlgorithm.Family.RSA.contains((Object)jweAlg)) {
                    jweObject.encrypt((JWEEncrypter)new RSAEncrypter((RSAPublicKey)encKey.getPublicKey()));
                    EncryptedJWT encJwt = EncryptedJWT.parse((String)jweObject.serialize());
                    assert (encJwt != null);
                    return encJwt;
                }
                if (JWEAlgorithm.Family.AES_KW.contains((Object)jweAlg) || JWEAlgorithm.Family.AES_GCM_KW.contains((Object)jweAlg)) {
                    jweObject.encrypt((JWEEncrypter)new AESEncrypter(encKey.getSecretKey()));
                    EncryptedJWT encJwt = EncryptedJWT.parse((String)jweObject.serialize());
                    assert (encJwt != null);
                    return encJwt;
                }
                if (JWEAlgorithm.Family.ECDH_ES.contains((Object)jweAlg)) {
                    jweObject.encrypt((JWEEncrypter)new ECDHEncrypter((ECPublicKey)encKey.getPublicKey()));
                    EncryptedJWT encJwt = EncryptedJWT.parse((String)jweObject.serialize());
                    assert (encJwt != null);
                    return encJwt;
                }
                if (JWEAlgorithm.DIR == jweAlg) {
                    jweObject.encrypt((JWEEncrypter)new DirectEncrypter(encKey.getSecretKey()));
                    EncryptedJWT encJwt = EncryptedJWT.parse((String)jweObject.serialize());
                    assert (encJwt != null);
                    return encJwt;
                }
            } else {
                return signedJWT;
            }
        }
        return new PlainJWT(payload);
    }

    @Nonnull
    public static JWT createJWTUserInfoResponse(Map<String, Object> overrideClaims, @Nullable JWSAlgorithm sigAlg, @Nullable JWEAlgorithm jweAlg, @Nullable EncryptionMethod enc, @Nullable Credential sigKey, @Nullable Credential encKey) throws JOSEException, ParseException {
        JWTClaimsSet payload = TestTokenHelper.createBasicUserInfoClaims(overrideClaims);
        return TestTokenHelper.createJWT(payload, sigAlg, jweAlg, enc, sigKey, encKey);
    }

    @Nonnull
    public static String createAccessTokenResponseJSON(Map<String, Object> overrideClaims, @Nullable JWSAlgorithm sigAlg, @Nullable JWEAlgorithm jweAlg, @Nullable EncryptionMethod enc, @Nullable Credential sigKey, @Nullable Credential encKey) throws Exception {
        JWTClaimsSet payload = TestTokenHelper.createBasicClaims(overrideClaims);
        JWT idToken = TestTokenHelper.createJWT(payload, sigAlg, jweAlg, enc, sigKey, encKey);
        return TestTokenHelper.buildTemplateAccessTokenJSONResponse(idToken.serialize());
    }

    @Nonnull
    public static String createPlainUserInfoResponseString(Map<String, Object> overrideClaims) throws JsonProcessingException {
        JWTClaimsSet claims = TestTokenHelper.createBasicUserInfoClaims(overrideClaims);
        String valueAsString = new ObjectMapper().writeValueAsString((Object)claims.toJSONObject());
        assert (valueAsString != null);
        return valueAsString;
    }

    @Nonnull
    public static PlainJWT createPlainJWTUserInfoResponseJSON(Map<String, Object> overrideClaims) throws JOSEException {
        JWTClaimsSet payload = TestTokenHelper.createBasicUserInfoClaims(overrideClaims);
        return new PlainJWT(payload);
    }

    @Nonnull
    private static String buildTemplateAccessTokenJSONResponse(String serializedJWT) {
        return "{\n  \"access_token\": \"W0y5aDNAzEPNpSzu1cuMG904BZuQFZJUUwG5F3ct0zydZWy1ji\",\n  \"token_type\": \"Bearer\",\n  \"id_token\": \"" + serializedJWT + "\",\n  \"scope\": \"openid\"\n}";
    }
}

