/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic.UserInfoPlainResponseTypeCondition;
import net.shibboleth.idp.plugin.authn.oidc.rp.test.TestTokenHelper;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UserInfoPlainResponseTypeConditionTest {
    private static final String CLIENT_SECRET = "Xp2s5v8y/B?E(H+MbQeThWmYq3t6w9z$";
    private UserInfoPlainResponseTypeCondition condition;
    private UserInfoResponseContext ctx;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
        this.ctx = new UserInfoResponseContext();
    }

    @Test
    public void testUserInfoIsPlain() {
        this.ctx.setUserInfo(new UserInfoSuccessResponse(new UserInfo(new Subject("subject"))));
        this.condition = new UserInfoPlainResponseTypeCondition(prcIn -> this.ctx);
        Assert.assertTrue((boolean)this.condition.test(this.prc));
    }

    @Test
    public void testUserInfoNoResponse() {
        this.ctx.setUserInfo(null);
        this.condition = new UserInfoPlainResponseTypeCondition(prcIn -> this.ctx);
        Assert.assertFalse((boolean)this.condition.test(this.prc));
    }

    @Test
    public void testUserInfoIsJWT() throws JOSEException, ParseException {
        JWT userInfoResp = TestTokenHelper.createJWTUserInfoResponse(Map.of("iss", "issuer", "aud", List.of("client_id")), null, null, EncryptionMethod.A128CBC_HS256, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        this.ctx.setUserInfo(new UserInfoSuccessResponse(userInfoResp));
        this.condition = new UserInfoPlainResponseTypeCondition(prcIn -> this.ctx);
        Assert.assertFalse((boolean)this.condition.test(this.prc));
    }
}

