/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import net.shibboleth.idp.plugin.authn.oidc.rp.context.AbstractAuthenticatableOIDCContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic.RequiresSignatureVerificationPredicate;
import net.shibboleth.oidc.profile.config.impl.DefaultOIDCAuthorizationConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequiresSignatureVerificationPredicateTest {
    private RequiresSignatureVerificationPredicate predicate;
    private RelyingPartyContext rpc;
    private DefaultOIDCAuthorizationConfiguration config;
    private MessageContext msgCtx;

    @BeforeMethod
    public void setup() {
        this.msgCtx = new MessageContext();
        ProfileRequestContext prc = new ProfileRequestContext();
        prc.setInboundMessageContext(this.msgCtx);
        this.rpc = new RelyingPartyContext();
        this.config = new DefaultOIDCAuthorizationConfiguration();
        this.rpc.setProfileConfig((ProfileConfiguration)this.config);
    }

    @Test
    public void testSignatureVerificationRequired_TLSOnlyDisabled() {
        this.predicate = new RequiresSignatureVerificationPredicate(msg -> new MockAuthenticatableContext(true));
        this.predicate.setRelyingPartyContextLookupStrategy(mc -> {
            this.config.setTlsServerValidationSufficient(false);
            return this.rpc;
        });
        Assert.assertTrue((boolean)this.predicate.test(this.msgCtx));
    }

    @Test
    public void testSignatureVerificationRequired_TLSOnlyDisabled_ContextNotAuthenticated() {
        this.predicate = new RequiresSignatureVerificationPredicate(msg -> new MockAuthenticatableContext(false));
        this.predicate.setRelyingPartyContextLookupStrategy(mc -> {
            this.config.setTlsServerValidationSufficient(false);
            return this.rpc;
        });
        Assert.assertTrue((boolean)this.predicate.test(this.msgCtx));
    }

    @Test
    public void testSignatureVerificationRequired_TLSOnlyEnabled_ContextNotAuthenticated() {
        this.predicate = new RequiresSignatureVerificationPredicate(msg -> new MockAuthenticatableContext(false));
        this.predicate.setRelyingPartyContextLookupStrategy(mc -> {
            this.config.setTlsServerValidationSufficient(true);
            return this.rpc;
        });
        Assert.assertTrue((boolean)this.predicate.test(this.msgCtx));
    }

    @Test
    public void testSignatureVerificationNotRequired_TLSOnlyEnabled() {
        this.predicate = new RequiresSignatureVerificationPredicate(msg -> new MockAuthenticatableContext(true));
        this.predicate.setRelyingPartyContextLookupStrategy(mc -> {
            this.config.setTlsServerValidationSufficient(true);
            return this.rpc;
        });
        Assert.assertFalse((boolean)this.predicate.test(this.msgCtx));
    }

    private static class MockAuthenticatableContext
    extends AbstractAuthenticatableOIDCContext {
        private MockAuthenticatableContext(boolean authn) {
            super.setAuthenticated(authn);
        }
    }
}

