/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic.RequestObjectRequiredAndSupported;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.config.impl.DefaultOIDCAuthorizationConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestObjectRequiredAndSupportedTest {
    private RequestObjectRequiredAndSupported predicate;
    private ProfileRequestContext prc;
    private RelyingPartyContext rpc;
    private DefaultOIDCAuthorizationConfiguration config;
    private OIDCProviderMetadataContext providerCtx;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
        this.rpc = new RelyingPartyContext();
        this.config = new DefaultOIDCAuthorizationConfiguration();
        this.rpc.setProfileConfig((ProfileConfiguration)this.config);
        this.providerCtx = new OIDCProviderMetadataContext();
    }

    @Test
    public void testRequestObjectEnabled_NoProviderContext() {
        this.config.setUseRequestObject(true);
        this.predicate = new RequestObjectRequiredAndSupported();
        this.predicate.setOidcProviderMetadataContextLookupStrategy(msg -> null);
        Assert.assertFalse((boolean)this.predicate.test(this.prc));
    }

    @Test
    public void testRequestObjectEnabled_NoMetadata() {
        this.config.setUseRequestObject(true);
        this.predicate = new RequestObjectRequiredAndSupported();
        this.predicate.setOidcProviderMetadataContextLookupStrategy(msg -> this.providerCtx);
        Assert.assertFalse((boolean)this.predicate.test(this.prc));
    }

    @Test
    public void testRequestObjectEnabledAndSupported() {
        this.config.setUseRequestObject(true);
        this.predicate = new RequestObjectRequiredAndSupported();
        try {
            OIDCProviderMetadata metadata = new OIDCProviderMetadata(new Issuer("test"), List.of(SubjectType.PUBLIC), new URI("nowhere"));
            metadata.setSupportsRequestParam(true);
            this.providerCtx.setProviderInformation(metadata);
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.predicate.setOidcProviderMetadataContextLookupStrategy(msg -> this.providerCtx);
        this.predicate.setRelyingPartyContextLookupStrategy(mc -> {
            this.config.setUseRequestObject(true);
            return this.rpc;
        });
        Assert.assertTrue((boolean)this.predicate.test(this.prc));
    }

    @Test
    public void testRequestObjectNotEnabledAndSupported() {
        this.config.setUseRequestObject(true);
        this.predicate = new RequestObjectRequiredAndSupported();
        try {
            OIDCProviderMetadata metadata = new OIDCProviderMetadata(new Issuer("test"), List.of(SubjectType.PUBLIC), new URI("nowhere"));
            metadata.setSupportsRequestParam(false);
            this.providerCtx.setProviderInformation(metadata);
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.predicate.setOidcProviderMetadataContextLookupStrategy(msg -> this.providerCtx);
        this.predicate.setRelyingPartyContextLookupStrategy(mc -> {
            this.config.setUseRequestObject(true);
            return this.rpc;
        });
        Assert.assertFalse((boolean)this.predicate.test(this.prc));
    }
}

