/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.UserInfoInUserInfoResponseContextUpdateStrategy;
import net.shibboleth.idp.plugin.authn.oidc.rp.test.TestTokenHelper;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UserInfoInUserInfoResponseContextUpdateStrategyTest {
    private static final String CLIENT_SECRET = "Xp2s5v8y/B?E(H+MbQeThWmYq3t6w9z$";
    private UserInfoInUserInfoResponseContextUpdateStrategy strategy;

    @Test
    public void testUpdateEncryptedToSigned() throws Exception {
        JWT userInfoRespOriginal = TestTokenHelper.createJWTUserInfoResponse(Map.of("iss", "issuer", "aud", List.of("client_id")), JWSAlgorithm.HS256, JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toEncryptionCredential(JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256));
        UserInfoResponseContext ctx = new UserInfoResponseContext();
        ctx.setUserInfo(new UserInfoSuccessResponse(userInfoRespOriginal));
        this.strategy = new UserInfoInUserInfoResponseContextUpdateStrategy(prc -> ctx);
        JWT userInfoRespNew = TestTokenHelper.createJWTUserInfoResponse(Map.of("iss", "issuer", "aud", List.of("client_id")), JWSAlgorithm.HS256, null, null, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        Assert.assertNotNull((Object)ctx.getUserInfo());
        Assert.assertNotNull((Object)ctx.getUserInfo().getUserInfoJWT());
        Assert.assertTrue((boolean)(ctx.getUserInfo().getUserInfoJWT() instanceof EncryptedJWT));
        this.strategy.accept(new ProfileRequestContext(), userInfoRespNew);
        Assert.assertNotNull((Object)ctx.getUserInfo());
        Assert.assertNotNull((Object)ctx.getUserInfo().getUserInfoJWT());
        Assert.assertTrue((boolean)(ctx.getUserInfo().getUserInfoJWT() instanceof SignedJWT));
        Assert.assertEquals((Object)ctx.getUserInfo().getUserInfoJWT(), (Object)userInfoRespNew);
    }
}

