/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.SubFromIDTokenLookupFunction;
import net.shibboleth.idp.plugin.authn.oidc.rp.test.TestTokenHelper;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SubFromIDTokenLookupFunctionTest {
    private static final String CLIENT_SECRET = "Xp2s5v8y/B?E(H+MbQeThWmYq3t6w9z$";
    private static final String SUBJECT = "test_client";
    private SubFromIDTokenLookupFunction function;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
    }

    @Test
    public void getSubInIDToken() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Map.of("sub", SUBJECT), JWSAlgorithm.HS256, null, null, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        AccessTokenResponseContext ctx = new AccessTokenResponseContext();
        try {
            ctx.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        }
        catch (ParseException e) {
            Assert.fail((String)e.getMessage());
        }
        this.function = new SubFromIDTokenLookupFunction(prc -> ctx);
        Assert.assertEquals((String)this.function.apply(this.prc, new JWTClaimsSet.Builder().build()), (String)SUBJECT);
    }

    @Test
    public void getSubInIDToken_Encrypted_NullResponse() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Map.of("sub", SUBJECT), JWSAlgorithm.HS256, JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toEncryptionCredential(JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256));
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        AccessTokenResponseContext ctx = new AccessTokenResponseContext();
        try {
            ctx.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        }
        catch (ParseException e) {
            Assert.fail((String)e.getMessage());
        }
        this.function = new SubFromIDTokenLookupFunction(prc -> ctx);
        Assert.assertEquals((String)this.function.apply(this.prc, new JWTClaimsSet.Builder().build()), null);
    }

    @Test
    public void getSubInIDToken_NoContext() throws Exception {
        this.function = new SubFromIDTokenLookupFunction(prc -> null);
        Assert.assertEquals((String)this.function.apply(this.prc, new JWTClaimsSet.Builder().build()), null);
    }

    @Test
    public void getSubInIDToken_NoTokenResponse() throws Exception {
        AccessTokenResponseContext ctx = new AccessTokenResponseContext();
        this.function = new SubFromIDTokenLookupFunction(prc -> ctx);
        Assert.assertEquals((String)this.function.apply(this.prc, new JWTClaimsSet.Builder().build()), null);
    }
}

