/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.Collections;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.IDTokenJOSEHeaderLookupStrategy;
import net.shibboleth.idp.plugin.authn.oidc.rp.test.TestTokenHelper;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IDTokenJOSEHeaderLookupStrategyTest {
    private static final String CLIENT_SECRET = "Xp2s5v8y/B?E(H+MbQeThWmYq3t6w9z$";
    private IDTokenJOSEHeaderLookupStrategy function;
    private ProfileRequestContext prc;
    private AccessTokenResponseContext testContext;

    @BeforeMethod
    public void setup() throws Exception {
        this.prc = new ProfileRequestContext();
        this.testContext = new AccessTokenResponseContext();
        this.function = new IDTokenJOSEHeaderLookupStrategy(prc -> this.testContext);
    }

    @Test
    public void testGetJOSEHeader() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Collections.emptyMap(), JWSAlgorithm.HS256, null, null, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.testContext.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        JWSHeader header = this.function.apply(this.prc);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)header.getAlgorithm(), (Object)JWSAlgorithm.HS256);
    }

    @Test
    public void testGetJOSEHeader_NoTokenResponse() throws Exception {
        this.testContext.setTokenResponse(null);
        JWSHeader header = this.function.apply(this.prc);
        Assert.assertNull((Object)header);
    }

    @Test
    public void testGetJOSEHeader_NoContext() throws Exception {
        this.function = new IDTokenJOSEHeaderLookupStrategy(prc -> null);
        JWSHeader header = this.function.apply(this.prc);
        Assert.assertNull((Object)header);
    }

    @Test
    public void testGetJOSEHeader_JWEType() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Collections.emptyMap(), JWSAlgorithm.HS256, JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toEncryptionCredential((JWEAlgorithm)Constraint.isNotNull((Object)JWEAlgorithm.DIR, (String)""), (EncryptionMethod)Constraint.isNotNull((Object)EncryptionMethod.A128CBC_HS256, (String)"")));
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.testContext.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        JWSHeader header = this.function.apply(this.prc);
        Assert.assertNull((Object)header);
    }
}

