/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.Collections;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.IDTokenInAccessTokenUpdateStrategy;
import net.shibboleth.idp.plugin.authn.oidc.rp.test.TestTokenHelper;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IDTokenInAccessTokenUpdateStrategyTest {
    private static final String CLIENT_SECRET = "Xp2s5v8y/B?E(H+MbQeThWmYq3t6w9z$";
    private IDTokenInAccessTokenUpdateStrategy strategy;

    @Test
    public void testUpdateEncryptedToSigned() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Collections.emptyMap(), JWSAlgorithm.HS256, JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toEncryptionCredential((JWEAlgorithm)Constraint.isNotNull((Object)JWEAlgorithm.DIR, (String)""), (EncryptionMethod)Constraint.isNotNull((Object)EncryptionMethod.A128CBC_HS256, (String)"")));
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        JWT jwtToUpdate = TestTokenHelper.createJWT(TestTokenHelper.createBasicClaims(Collections.emptyMap()), JWSAlgorithm.HS256, null, null, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        AccessTokenResponseContext ctx = new AccessTokenResponseContext();
        try {
            ctx.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        }
        catch (ParseException e) {
            Assert.fail((String)e.getMessage());
        }
        this.strategy = new IDTokenInAccessTokenUpdateStrategy(prc -> ctx);
        Assert.assertNotNull((Object)ctx.getTokenResponse());
        OIDCTokenResponse tokenResponseFromCtx = ctx.getTokenResponse();
        assert (tokenResponseFromCtx != null);
        Assert.assertNotNull((Object)tokenResponseFromCtx.getTokens());
        Assert.assertNotNull((Object)tokenResponseFromCtx.getTokens().getAccessToken());
        Assert.assertNotNull((Object)tokenResponseFromCtx.getTokens().getBearerAccessToken());
        Assert.assertNotNull((Object)tokenResponseFromCtx.getOIDCTokens());
        Assert.assertNotNull((Object)tokenResponseFromCtx.getOIDCTokens().getIDToken());
        Assert.assertTrue((boolean)(tokenResponseFromCtx.getOIDCTokens().getIDToken() instanceof EncryptedJWT));
        this.strategy.accept(new ProfileRequestContext(), jwtToUpdate);
        OIDCTokenResponse tokenResponseFromCtxAfter = ctx.getTokenResponse();
        assert (tokenResponseFromCtxAfter != null);
        Assert.assertNotNull((Object)tokenResponseFromCtxAfter);
        Assert.assertNotNull((Object)tokenResponseFromCtxAfter.getTokens());
        Assert.assertNotNull((Object)tokenResponseFromCtxAfter.getTokens().getAccessToken());
        Assert.assertNotNull((Object)tokenResponseFromCtxAfter.getTokens().getBearerAccessToken());
        Assert.assertNotNull((Object)tokenResponseFromCtxAfter.getOIDCTokens());
        Assert.assertNotNull((Object)tokenResponseFromCtxAfter.getOIDCTokens().getIDToken());
        Assert.assertTrue((boolean)(tokenResponseFromCtxAfter.getOIDCTokens().getIDToken() instanceof SignedJWT));
    }
}

