/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.EncryptedUserInfoJWTLookupStrategy;
import net.shibboleth.idp.plugin.authn.oidc.rp.test.TestTokenHelper;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptedUserInfoJWTLookupStrategyTest {
    private static final String CLIENT_ID = "test_client";
    private static final String CLIENT_SECRET = "Xp2s5v8y/B?E(H+MbQeThWmYq3t6w9z$";
    private EncryptedUserInfoJWTLookupStrategy function;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
    }

    @Test
    public void testGetEncryptedUserInfoToken() throws Exception {
        JWT userInfoResp = TestTokenHelper.createJWTUserInfoResponse(Map.of("iss", "issuer", "aud", List.of(CLIENT_ID)), JWSAlgorithm.HS256, JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toEncryptionCredential(JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256));
        UserInfoResponseContext ctx = new UserInfoResponseContext();
        ctx.setUserInfo(new UserInfoSuccessResponse(userInfoResp));
        this.function = new EncryptedUserInfoJWTLookupStrategy(prc -> ctx);
        Assert.assertNotNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testGetEncryptedUserInfoToken_NotEncrypted() throws Exception {
        JWT userInfoResp = TestTokenHelper.createJWTUserInfoResponse(Map.of("iss", "issuer", "aud", List.of(CLIENT_ID)), JWSAlgorithm.HS256, null, null, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        UserInfoResponseContext ctx = new UserInfoResponseContext();
        ctx.setUserInfo(new UserInfoSuccessResponse(userInfoResp));
        this.function = new EncryptedUserInfoJWTLookupStrategy(prc -> ctx);
        Assert.assertNull((Object)this.function.apply(this.prc));
    }
}

