/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.Collections;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.EncryptedIDTokenLookupStrategy;
import net.shibboleth.idp.plugin.authn.oidc.rp.test.TestTokenHelper;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptedIDTokenLookupStrategyTest {
    private static final String CLIENT_SECRET = "Xp2s5v8y/B?E(H+MbQeThWmYq3t6w9z$";
    private EncryptedIDTokenLookupStrategy function;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
    }

    @Test
    public void testGetEncryptedIDToken() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Collections.emptyMap(), JWSAlgorithm.HS256, JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toEncryptionCredential((JWEAlgorithm)Constraint.isNotNull((Object)JWEAlgorithm.DIR, (String)"alg can not be null"), (EncryptionMethod)Constraint.isNotNull((Object)EncryptionMethod.A128CBC_HS256, (String)"alg can not be null")));
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        AccessTokenResponseContext ctx = new AccessTokenResponseContext();
        try {
            ctx.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        }
        catch (ParseException e) {
            Assert.fail((String)e.getMessage());
        }
        this.function = new EncryptedIDTokenLookupStrategy(prc -> ctx);
        Assert.assertNotNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testGetEncryptedIDToken_NotEncrypted() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Collections.emptyMap(), JWSAlgorithm.HS256, null, null, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        AccessTokenResponseContext ctx = new AccessTokenResponseContext();
        try {
            ctx.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        }
        catch (ParseException e) {
            Assert.fail((String)e.getMessage());
        }
        this.function = new EncryptedIDTokenLookupStrategy(prc -> ctx);
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testGetEncryptedIDToken_NoIDToken() throws Exception {
        String tokenResponse = TestTokenHelper.createAccessTokenResponseJSON(Collections.emptyMap(), JWSAlgorithm.HS256, null, null, (Credential)new DefaultClientSecretCredential(CLIENT_SECRET).toSigningCredential(), null);
        Map tokenResponseAsMap = (Map)new ObjectMapper().readValue(tokenResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
        tokenResponseAsMap.remove("id_token");
        AccessTokenResponseContext ctx = new AccessTokenResponseContext();
        try {
            ctx.setTokenResponse(OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap)));
        }
        catch (ParseException e) {
            Assert.fail((String)e.getMessage());
        }
        this.function = new EncryptedIDTokenLookupStrategy(prc -> ctx);
        Assert.assertNull((Object)this.function.apply(this.prc));
    }
}

