/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.text.ParseException;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.DefaultIDTokenLookupStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultIDTokenLookupStrategyTest {
    private static final String SUBJECT = "test_client";
    private DefaultIDTokenLookupStrategy function;
    private ProfileRequestContext prc;
    private AccessTokenResponseContext testContext;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
        this.testContext = new AccessTokenResponseContext();
        this.function = new DefaultIDTokenLookupStrategy(prc -> this.testContext);
        PlainJWT idToken = new PlainJWT(new JWTClaimsSet.Builder().subject(SUBJECT).build());
        OIDCTokenResponse response = new OIDCTokenResponse(new OIDCTokens((JWT)idToken, (AccessToken)new BearerAccessToken(), new RefreshToken()));
        this.testContext.setTokenResponse(response);
    }

    @Test
    public void testGetIDToken() throws ParseException {
        Assert.assertEquals((String)this.function.apply(this.prc).getJWTClaimsSet().getSubject(), (String)SUBJECT);
    }

    @Test
    public void testGetIDToken_NoContext() {
        this.function = new DefaultIDTokenLookupStrategy(prc -> null);
        Assert.assertEquals((Object)this.function.apply(this.prc), null);
    }

    @Test
    public void testGetIDTokens_emptyIDToken() throws ParseException {
        OIDCTokenResponse response = new OIDCTokenResponse(new OIDCTokens((JWT)new PlainJWT(new JWTClaimsSet.Builder().build()), (AccessToken)new BearerAccessToken(), new RefreshToken()));
        this.testContext.setTokenResponse(response);
        Assert.assertEquals((String)this.function.apply(this.prc).getJWTClaimsSet().getSubject(), null);
    }
}

