/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.text.ParseException;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.DefaultUserInfoJWTLookupStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaulUserInfoJWTLookupStrategyTest {
    private static final String SUBJECT = "test_client";
    private DefaultUserInfoJWTLookupStrategy function;
    private ProfileRequestContext prc;
    private UserInfoResponseContext testContext;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
        this.testContext = new UserInfoResponseContext();
        this.function = new DefaultUserInfoJWTLookupStrategy(prc -> this.testContext);
        PlainJWT idToken = new PlainJWT(new JWTClaimsSet.Builder().subject(SUBJECT).build());
        UserInfoSuccessResponse response = new UserInfoSuccessResponse((JWT)idToken);
        this.testContext.setUserInfo(response);
    }

    @Test
    public void testGetUserInfoToken() throws ParseException {
        Assert.assertEquals((String)this.function.apply(this.prc).getJWTClaimsSet().getSubject(), (String)SUBJECT);
    }

    @Test
    public void testGetUserInfoToken_NoContext() {
        this.function = new DefaultUserInfoJWTLookupStrategy(prc -> null);
        Assert.assertEquals((Object)this.function.apply(this.prc), null);
    }

    @Test
    public void testGetUserInfo_NotJWTType() throws ParseException {
        ClaimsSet set = new ClaimsSet();
        set.setClaim("sub", (Object)SUBJECT);
        UserInfoSuccessResponse response = new UserInfoSuccessResponse(new UserInfo(set.toJSONObject()));
        this.testContext.setUserInfo(response);
        Assert.assertEquals((Object)this.function.apply(this.prc), null);
    }
}

