/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWTClaimsSet;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.OAuth2ClientContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.ClientIDFromOAuth2ClientContextFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ClientIDFromOAuth2ClientContextFunctionTest {
    private static final String CLIENT_ID = "test_client";
    private ClientIDFromOAuth2ClientContextFunction function;
    private ProfileRequestContext prc;
    private OAuth2ClientContext testContext;

    @BeforeMethod
    public void setup() {
        this.prc = new ProfileRequestContext();
        this.testContext = new OAuth2ClientContext();
        this.function = new ClientIDFromOAuth2ClientContextFunction(prc -> this.testContext);
    }

    @Test
    public void testGetClientID() {
        this.testContext.setClientId(CLIENT_ID);
        Assert.assertEquals((String)this.function.apply(this.prc, new JWTClaimsSet.Builder().build()), (String)CLIENT_ID);
    }

    @Test
    public void testGetClientID_NoClientID() {
        Assert.assertEquals((String)this.function.apply(this.prc, new JWTClaimsSet.Builder().build()), null);
    }

    @Test
    public void testGetClientID_NoClientContext() {
        this.function = new ClientIDFromOAuth2ClientContextFunction(prc -> null);
        Assert.assertEquals((String)this.function.apply(this.prc, new JWTClaimsSet.Builder().build()), null);
    }
}

