/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.sdk.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.sdk.impl.DuoSDKClientAdaptor;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DuoSDKClientFactory
extends AbstractInitializableComponent
implements DuoOIDCClientFactory {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DuoSDKClientFactory.class);
    @Nullable
    @GuardedBy(value="this")
    @NonnullElements
    @Unmodifiable
    private List<String> caCerts;

    public synchronized void setCaCerts(@Nullable List<String> certs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.caCerts = certs != null ? List.copyOf(StringSupport.normalizeStringCollection(certs)) : null;
    }

    @Nullable
    @NonnullElements
    @Unmodifiable
    private synchronized List<String> getCaCerts() {
        return this.caCerts;
    }

    @Nonnull
    public DuoOIDCClient createInstance(@Nonnull DuoOIDCIntegration integration) throws DuoClientException {
        return new DuoSDKClientAdaptor(integration, this.getCaCerts());
    }
}

