/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DefaultDuoOIDCIntegration
extends AbstractInitializableComponent
implements DuoOIDCIntegration {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultDuoOIDCIntegration.class);
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String apiHost;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String clientId;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String secretKey;
    @Nullable
    @GuardedBy(value="this")
    private String redirectURI;
    @Nullable
    @GuardedBy(value="this")
    private String registeredRedirectURI;
    @Nonnull
    @GuardedBy(value="this")
    @NonnullElements
    @Unmodifiable
    private Set<String> allowedOrigins;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String healthEndpoint;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String authorizeEndpoint;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String tokenEndpoint;
    @Nonnull
    @GuardedBy(value="this")
    private final Subject supportedPrincipals = new Subject();

    public DefaultDuoOIDCIntegration() {
        this.allowedOrigins = Collections.emptySet();
    }

    public synchronized void setAllowedOrigins(@Nullable @NonnullElements Collection<String> hosts) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.allowedOrigins = Set.copyOf(StringSupport.normalizeStringCollection((Collection)((Collection)Constraint.isNotNull(hosts, (String)"Types cannot be null"))));
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public synchronized Set<String> getAllowedOrigins() {
        return Collections.unmodifiableSet(this.allowedOrigins);
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getAPIHost() {
        return this.apiHost;
    }

    public synchronized void setAPIHost(@Nonnull @NotEmpty String host) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.apiHost = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)host), (String)"API host cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getHealthCheckEndpoint() {
        return this.healthEndpoint;
    }

    public synchronized void setHealthCheckEndpoint(@Nonnull @NotEmpty String endpoint) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.healthEndpoint = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)endpoint), (String)"Health check endpoint cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getAuthorizeEndpoint() {
        return this.authorizeEndpoint;
    }

    public synchronized void setAuthorizeEndpoint(@Nonnull @NotEmpty String endpoint) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authorizeEndpoint = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)endpoint), (String)"Authorize endpoint cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public synchronized void setTokenEndpoint(@Nonnull @NotEmpty String endpoint) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenEndpoint = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)endpoint), (String)"Token endpoint cannot be null or empty");
    }

    public synchronized void setRedirectURI(@Nullable String uri) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.redirectURI = StringSupport.trimOrNull((String)uri);
    }

    @Override
    @Nullable
    public synchronized String getRedirectURI() {
        return this.redirectURI;
    }

    public synchronized void setRegisteredRedirectURI(@Nullable String uri) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.registeredRedirectURI = StringSupport.trimOrNull((String)uri);
    }

    @Override
    @Nullable
    public synchronized String getRegisteredRedirectURI() {
        return this.registeredRedirectURI;
    }

    @Override
    public synchronized boolean isRedirectURIPreregistered() {
        return this.getRegisteredRedirectURI() != null;
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized void setRedirectURIIfAbsent(@Nonnull @NotEmpty String computedRedirectURI) {
        Constraint.isNotEmpty((String)computedRedirectURI, (String)"Computed redirect URI can not be null or empty");
        if (this.redirectURI == null) {
            this.log.debug("Redirect_uri is being set as '{}'", (Object)computedRedirectURI);
            this.redirectURI = computedRedirectURI;
        }
    }

    public synchronized void setClientId(@Nonnull @NotEmpty String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"ClientID cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getClientId() {
        return this.clientId;
    }

    public synchronized void setSecretKey(@Nonnull @NotEmpty String key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.secretKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Secret key cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getSecretKey() {
        return this.secretKey;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public synchronized <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.supportedPrincipals.getPrincipals(c);
    }

    public synchronized <T extends Principal> void setSupportedPrincipals(@Nullable @NonnullElements Collection<T> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportedPrincipals.getPrincipals().clear();
        if (principals != null && !principals.isEmpty()) {
            this.supportedPrincipals.getPrincipals().addAll(Set.copyOf(principals));
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.getAPIHost() == null || this.getClientId() == null || this.getSecretKey() == null || this.getHealthCheckEndpoint() == null || this.getAuthorizeEndpoint() == null || this.getTokenEndpoint() == null || this.getRedirectURI() == null && this.getAllowedOrigins() == null) {
            throw new ComponentInitializationException("API host, clientId, secret key,token endpoint, health check endpoint, authorization endpoint, and one ofredirectURI or allowed redirect URI origins must be set");
        }
    }

    public int hashCode() {
        return Objects.hash(this.getClientId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultDuoOIDCIntegration other = (DefaultDuoOIDCIntegration)obj;
        return Objects.equals(this.getClientId(), other.getClientId());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultDuoOIDCIntegration [apiHost=");
        builder.append(this.apiHost);
        builder.append(", clientId=");
        builder.append(this.clientId);
        builder.append(", redirectURI=");
        builder.append(this.redirectURI);
        builder.append("]");
        return builder.toString();
    }
}

