/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.URISupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public final class DefaultRedirectURICreationStrategy
implements BiFunction<HttpServletRequest, DuoOIDCIntegration, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultRedirectURICreationStrategy.class);
    @Nonnull
    @NotEmpty
    private final String callbackServletPath;

    public DefaultRedirectURICreationStrategy(@Nonnull @NotEmpty String callbackPath) {
        this.callbackServletPath = (String)Constraint.isNotNull((Object)callbackPath, (String)"Duo Call back path can not be null");
    }

    @Override
    @Nullable
    public String apply(@Nonnull HttpServletRequest request, @Nonnull DuoOIDCIntegration integration) {
        String redirectFromIntegration = integration.getRegisteredRedirectURI();
        if (redirectFromIntegration != null) {
            this.log.trace("Using redirect_uri '{}' from the Duo integration settings", (Object)redirectFromIntegration);
            return redirectFromIntegration;
        }
        try {
            URI uri = URISupport.buildURIIgnoreDefaultPorts((String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort(), (String)(request.getContextPath() + request.getServletPath() + this.callbackServletPath));
            String origin = URISupport.buildOrigin((URI)uri);
            if (!integration.getAllowedOrigins().contains(origin)) {
                this.log.warn("The 'origin' of the computed redirect_uri ('{}') is not allowed", (Object)origin);
                return null;
            }
            return uri.toString();
        }
        catch (URISyntaxException e) {
            this.log.warn("Unable to generate redirectURI", (Throwable)e);
            return null;
        }
    }
}

