/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.nimbus.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.util.IOUtils;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheck;
import net.shibboleth.idp.plugin.authn.duo.nimbus.impl.NimbusClientSupport;
import net.shibboleth.idp.plugin.authn.duo.nimbus.impl.TokenResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public final class NimbusClient
extends AbstractDuoOIDCClient {
    @Nonnull
    @NotEmpty
    private static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    @Nonnull
    @NotEmpty
    private static final String HTTPS = "https";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NimbusClient.class);
    @Nonnull
    private final DuoOIDCIntegration duoIntegration;
    @Nonnull
    private final HttpClient httpClient;
    @Nullable
    private final HttpClientSecurityParameters httpClientSecurityParameters;
    @Nonnull
    private final ObjectMapper objectMapper;

    NimbusClient(@Nonnull DuoOIDCIntegration integration, @Nonnull HttpClient client, @Nullable HttpClientSecurityParameters params, @Nonnull ObjectMapper oMapper) {
        this.duoIntegration = (DuoOIDCIntegration)Constraint.isNotNull((Object)integration, (String)"Nimbus Client requires a non-null Duo Integration");
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"Nimbus Client requires a non-null http client");
        this.httpClientSecurityParameters = params;
        this.objectMapper = oMapper;
    }

    @Nonnull
    public DuoHealthCheck healthCheck() throws DuoClientException {
        try {
            URI uri = new URIBuilder().setScheme(HTTPS).setHost(this.duoIntegration.getAPIHost()).setPath(this.duoIntegration.getHealthCheckEndpoint()).build();
            this.log.trace("Using health check endpoint '{}'", (Object)uri);
            RequestBuilder rb = RequestBuilder.post().setUri(uri).addParameter("client_id", this.duoIntegration.getClientId()).addParameter("client_assertion", NimbusClientSupport.createJWS(uri.toString(), this.duoIntegration.getClientId(), this.duoIntegration.getSecretKey()));
            return this.executeRequest(rb.build(), new TypeReference<DuoHealthCheck>(){});
        }
        catch (URISyntaxException e) {
            throw new DuoClientException("Error performing a Duo health check", (Throwable)e);
        }
    }

    @Nonnull
    public String createAuthUrl(@Nonnull @NotEmpty String username, @Nonnull @NotEmpty String state, @Nullable String nonce, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)username, (String)"Username can not be null or empty");
        Constraint.isNotEmpty((String)state, (String)"State can not be null or empty");
        Constraint.isNotEmpty((String)nonce, (String)"Nonce can not be null or empty for this client");
        Constraint.isGreaterThan((int)21, (int)state.length(), (String)"State must be at least 22 characters");
        Constraint.isLessThan((int)1025, (int)state.length(), (String)"State must be at maximum 1024 characters");
        try {
            String redirectURI;
            String string = redirectURI = redirectURIOverride != null ? redirectURIOverride : this.duoIntegration.getRedirectURI();
            if (redirectURI == null) {
                throw new DuoClientException("A redirect_uri was not supplied but is required for creating an authorization request, for client '" + this.duoIntegration.getClientId() + "'");
            }
            String request = NimbusClientSupport.createJWSRequestObject(this.duoIntegration.getClientId(), redirectURI, this.duoIntegration.getSecretKey(), state, username);
            URI uri = new URIBuilder().setScheme(HTTPS).setHost(this.duoIntegration.getAPIHost()).setPath(this.duoIntegration.getAuthorizeEndpoint()).setParameter("scope", "openid").setParameter("nonce", nonce).setParameter("response_type", "code").setParameter("redirect_uri", redirectURI).setParameter("client_id", this.duoIntegration.getClientId()).setParameter("request", request).build();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new DuoClientException("Unable to create a Duo authorization URL", (Throwable)e);
        }
    }

    public JWT exchangeAuthorizationCodeFor2FAResult(@Nonnull String code, @Nonnull String username, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)code, (String)"Auth_code can not be null");
        try {
            String redirectURI;
            URI uri = new URIBuilder().setScheme(HTTPS).setHost(this.duoIntegration.getAPIHost()).setPath(this.duoIntegration.getTokenEndpoint()).build();
            this.log.trace("Using authorization endpoint and audience '{}'", (Object)uri);
            String string = redirectURI = redirectURIOverride != null ? redirectURIOverride : this.duoIntegration.getRedirectURI();
            if (redirectURI == null) {
                throw new DuoClientException("A redirect_uri was not supplied but is required for acquiring a 2FA result, for client '" + this.duoIntegration.getClientId() + "'");
            }
            RequestBuilder rb = RequestBuilder.post().setUri(uri).addParameter("grant_type", "authorization_code").addParameter("code", code).addParameter("redirect_uri", redirectURI).addParameter("client_assertion_type", CLIENT_ASSERTION_TYPE).addParameter("client_assertion", NimbusClientSupport.createJWS(uri.toString(), this.duoIntegration.getClientId(), this.duoIntegration.getSecretKey()));
            TokenResponse response = this.executeRequest(rb.build(), new TypeReference<TokenResponse>(){});
            this.log.trace("Duo token response: '{}'", (Object)response);
            return SignedJWT.parse((String)response.getIdToken());
        }
        catch (URISyntaxException | ParseException e) {
            throw new DuoClientException("Unable to swap auth_code for id_token", (Throwable)e);
        }
    }

    private <T> T executeRequest(@Nonnull HttpUriRequest request, @Nonnull TypeReference<T> wrapperTypeRef) throws DuoClientException {
        try {
            HttpClientContext clientContext = HttpClientContext.create();
            HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)true);
            HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpUriRequest)request);
            HttpResponse httpResponse = this.httpClient.execute(request, (HttpContext)clientContext);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)request.getURI().getScheme());
            int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
            if (httpStatusCode != 200) {
                if (httpResponse.getEntity() != null && httpResponse.getEntity().getContent() != null) {
                    String errorContent = IOUtils.readInputStreamToString((InputStream)httpResponse.getEntity().getContent());
                    this.log.error("Duo returned a Non-ok message of '{}'", (Object)errorContent);
                }
                throw new DuoClientException("Non-ok status code (" + httpStatusCode + ") returned from Duo: " + httpResponse.getStatusLine().getReasonPhrase());
            }
            if (httpResponse.getEntity() == null) {
                throw new DuoClientException("No response body returned from Duo");
            }
            Object duoResponse = this.objectMapper.readValue(httpResponse.getEntity().getContent(), wrapperTypeRef);
            if (duoResponse == null) {
                throw new DuoClientException("Unable to parse JSON response");
            }
            return (T)duoResponse;
        }
        catch (IOException e) {
            throw new DuoClientException("Could not execute Duo HTTP request", (Throwable)e);
        }
    }

    public boolean isSupportsNonce() {
        return true;
    }
}

