/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientRegistry;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DynamicDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.idp.session.context.navigate.CanonicalUsernameLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateDuoAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateDuoAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCAuthenticationContext> duoAuthContextCreationStrategy = new ChildContextLookup(DuoOIDCAuthenticationContext.class, true).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = new CanonicalUsernameLookupStrategy();
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCIntegration> duoIntegrationLookupStrategy = FunctionSupport.constant(null);
    @Nullable
    private BiFunction<HttpServletRequest, DynamicDuoOIDCIntegration, String> redirectURICreationStrategy;
    @NonnullAfterInit
    private DuoOIDCClientRegistry clientRegistry;

    public void setClientRegistry(@Nonnull DuoOIDCClientRegistry duoRegistry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.clientRegistry = (DuoOIDCClientRegistry)Constraint.isNotNull((Object)duoRegistry, (String)"DuoClient registry can not be null");
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setRedirectURICreationStrategy(@Nonnull BiFunction<HttpServletRequest, DynamicDuoOIDCIntegration, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.redirectURICreationStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"RedirectURI creation strategy cannot be null");
    }

    public void setDuoContextCreationStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.duoAuthContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoAuthenticationContext creation strategy cannot be null");
    }

    public void setDuoIntegrationLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCIntegration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.duoIntegrationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoIntegration lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientRegistry == null) {
            throw new ComponentInitializationException("Duo Client Registry cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        DuoOIDCAuthenticationContext context = this.duoAuthContextCreationStrategy.apply(profileRequestContext);
        if (context == null) {
            this.log.error("{} Error creating DuoAuthenticationContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        DuoOIDCIntegration duoIntegration = this.duoIntegrationLookupStrategy.apply(profileRequestContext);
        if (duoIntegration == null) {
            this.log.warn("{} No DuoIntegration returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        context.setIntegration(duoIntegration);
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.warn("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        String username = this.usernameLookupStrategy.apply(profileRequestContext);
        if (username == null) {
            this.log.warn("{} No principal name available to initiate a Duo 2FA request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        context.setUsername(username);
        String nonce = DuoSupport.generateNonce(32);
        context.setRequestState(nonce);
        try {
            this.computeAndStoreRedirectURIIfSupported(duoIntegration, request, context);
            DuoOIDCClient client = this.clientRegistry.getClientOrCreate(duoIntegration);
            context.setClient(client);
        }
        catch (DuoException e) {
            this.log.warn("{} Unable to establish a Duo Client for the given integration", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
            return;
        }
        this.log.debug("Created Duo authentication context for '{}'", (Object)username);
    }

    private void computeAndStoreRedirectURIIfSupported(@Nonnull DuoOIDCIntegration duoIntegration, @Nonnull HttpServletRequest request, @Nonnull DuoOIDCAuthenticationContext context) throws DuoException {
        if (duoIntegration instanceof DynamicDuoOIDCIntegration) {
            if (this.redirectURICreationStrategy == null) {
                throw new DuoException("A dynamic DuoOIDC integration was supplied, but the redirect URI creation strategy was null. Please set a redirect URI creation strategy.");
            }
            String redirectURI = this.redirectURICreationStrategy.apply(request, (DynamicDuoOIDCIntegration)duoIntegration);
            if (redirectURI == null) {
                throw new DuoException("A redirect_uri was not registered or could not be computed");
            }
            ((DynamicDuoOIDCIntegration)duoIntegration).setRedirectURIIfAbsent(redirectURI);
            this.log.trace("{} Adding a dynamic redirect_uri '{}' to the context for the DuoClient to use if supported", (Object)this.getLogPrefix(), (Object)redirectURI);
            context.setRedirectURIOverride(redirectURI);
        }
    }
}

