/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.security.SecureRandom;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

@ThreadSafe
public final class DuoSupport {
    private DuoSupport() {
    }

    @Nonnull
    static String generateNonce(@Nonnull Integer length) {
        Constraint.isGreaterThan((int)22, (int)length, (String)"Nonce must be at least 22 characters");
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(Integer.toHexString(secureRandom.nextInt()));
        }
        return sb.toString().substring(0, length);
    }

    @Nonnull
    static String generateState(@Nonnull String nonce, @Nonnull String key) {
        Constraint.isNotNull((Object)nonce, (String)"Nonce Hex key can not be null");
        Constraint.isNotNull((Object)key, (String)"Webflow execution key can not be null");
        String keyHex = Hex.encodeHexString((byte[])key.getBytes());
        return nonce + "." + keyHex;
    }

    @Nonnull
    static String extractKeyFromState(@Nonnull String state) throws DuoException {
        Constraint.isNotNull((Object)state, (String)"State can not be null");
        String[] stateSplit = state.split("\\.");
        if (stateSplit.length != 2) {
            throw new DuoException("State does not contain the key component");
        }
        String hexKey = stateSplit[1];
        try {
            return new String(Hex.decodeHex((String)hexKey));
        }
        catch (DecoderException e) {
            throw new DuoException("Can not hex decode key", (Throwable)e);
        }
    }

    @Nonnull
    static String extractNonceFromState(@Nonnull String state) throws DuoException {
        Constraint.isNotNull((Object)state, (String)"State can not be null");
        String[] stateSplit = state.split("\\.");
        if (stateSplit.length != 2) {
            throw new DuoException("State does not contain the nonce component");
        }
        return stateSplit[0];
    }
}

