/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.spring;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.validation.Validator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.validation.ValidationHintResolver;

public class CustomLocalFlowBuilderContext {
    private FlowBuilderContext parent;
    private ApplicationContext localFlowContext;

    public CustomLocalFlowBuilderContext(FlowBuilderContext parent, GenericApplicationContext localFlowContext) {
        this.parent = parent;
        this.localFlowContext = localFlowContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.localFlowContext;
    }

    public String getFlowId() {
        return this.parent.getFlowId();
    }

    public AttributeMap<Object> getFlowAttributes() {
        return this.parent.getFlowAttributes();
    }

    public FlowDefinitionLocator getFlowDefinitionLocator() {
        if (this.localFlowContext.containsLocalBean("flowRegistry")) {
            return (FlowDefinitionLocator)this.localFlowContext.getBean("flowRegistry", FlowDefinitionLocator.class);
        }
        return this.parent.getFlowDefinitionLocator();
    }

    public FlowArtifactFactory getFlowArtifactFactory() {
        if (this.localFlowContext.containsLocalBean("flowArtifactFactory")) {
            return (FlowArtifactFactory)this.localFlowContext.getBean("flowArtifactFactory", FlowArtifactFactory.class);
        }
        return this.parent.getFlowArtifactFactory();
    }

    public ConversionService getConversionService() {
        if (this.localFlowContext.containsLocalBean("conversionService")) {
            return (ConversionService)this.localFlowContext.getBean("conversionService", ConversionService.class);
        }
        return this.parent.getConversionService();
    }

    public ViewFactoryCreator getViewFactoryCreator() {
        if (this.localFlowContext.containsLocalBean("viewFactoryCreator")) {
            return (ViewFactoryCreator)this.localFlowContext.getBean("viewFactoryCreator", ViewFactoryCreator.class);
        }
        return this.parent.getViewFactoryCreator();
    }

    public ExpressionParser getExpressionParser() {
        if (this.localFlowContext.containsLocalBean("expressionParser")) {
            return (ExpressionParser)this.localFlowContext.getBean("expressionParser", ExpressionParser.class);
        }
        return this.parent.getExpressionParser();
    }

    public Validator getValidator() {
        if (this.localFlowContext.containsLocalBean("validator")) {
            return (Validator)this.localFlowContext.getBean("validator", Validator.class);
        }
        return this.parent.getValidator();
    }

    public ValidationHintResolver getValidationHintResolver() {
        if (this.localFlowContext.containsLocalBean("validationHintResolver")) {
            return (ValidationHintResolver)this.localFlowContext.getBean("validationHintResolver", ValidationHintResolver.class);
        }
        return this.parent.getValidationHintResolver();
    }
}

