/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.spring;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class CustomFlowRelativeResourceLoader
implements ResourceLoader {
    private final Set<ProtocolResolver> protocolResolvers = new LinkedHashSet<ProtocolResolver>(4);
    private final Resource flowResource;

    public void addProtocolResolver(ProtocolResolver resolver) {
        Assert.notNull((Object)resolver, (String)"ProtocolResolver must not be null");
        this.protocolResolvers.add(resolver);
    }

    public CustomFlowRelativeResourceLoader(Resource resource) {
        this.flowResource = resource;
    }

    public ClassLoader getClassLoader() {
        return this.flowResource.getClass().getClassLoader();
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        for (ProtocolResolver protocolResolver : this.protocolResolvers) {
            Resource resource = protocolResolver.resolve(location, (ResourceLoader)this);
            if (resource == null) continue;
            return resource;
        }
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        return this.createFlowRelativeResource(location);
    }

    private Resource createFlowRelativeResource(String location) {
        try {
            return this.flowResource.createRelative(location);
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Unable to access a flow relative resource at location '" + location + "'");
            iae.initCause(e);
            throw iae;
        }
    }
}

