/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.mock;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientCapabilities;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheck;
import net.shibboleth.oidc.security.JWSAssemblyUtils;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.codec.EncodingException;

public class MockDuoOIDCClient_OK_OLD_AUTH_TIME
implements DuoOIDCClient {
    @Nonnull
    private static final String STATUS = "OK";
    @Nonnull
    private static final String SUB = "jdoe";
    @NonnullAfterInit
    private final DuoOIDCIntegration integration;

    public MockDuoOIDCClient_OK_OLD_AUTH_TIME(@Nonnull DuoOIDCIntegration integ) throws DuoClientException {
        this.integration = integ;
    }

    public DuoHealthCheck healthCheck() throws DuoClientException {
        return DuoHealthCheck.builder().withStatus(STATUS).withTimestamp(Long.toString(System.currentTimeMillis())).build();
    }

    public String createAuthUrl(String username, String state, String nonce, String redirect) throws DuoClientException {
        return String.format("https://%s%s?scope=openid&response_type=code&redirect_uri=%s&client_id=%s&request=%s", this.integration.getAPIHost(), "/oauth/v1/authorize", this.integration.getRedirectURI(), this.integration.getClientId(), "JWT");
    }

    public JWT exchangeAuthorizationCodeFor2FAResult(String code, String username, String redirect) throws DuoClientException {
        String jwtJson = "{\n    \"iss\": \"https://" + this.integration.getAPIHost() + "/oauth/v1/token\",\n    \"sub\": \"jdoe\",\n    \"preferred_username\": \"jdoe\",\n    \"aud\": \"" + this.integration.getClientId() + "\",\n    \"exp\": " + new String(Math.toIntExact(Instant.now().plus(10L, ChronoUnit.MINUTES).getEpochSecond()) + ",\n    \"iat\": " + Long.toString(Instant.now().getEpochSecond())) + ",\n    \"auth_time\": " + Math.toIntExact(Instant.now().minus(10L, ChronoUnit.MINUTES).getEpochSecond()) + ",\n    \"auth_result\": {\n        \"status_msg\": \"Login Successful\",\n        \"status\": \"allow\",\n        \"result\": \"allow\"\n    },\n    \"auth_context\": {\n        \"result\": \"success\",\n        \"timestamp\": 1599749128,\n        \"auth_device\": {\n            \"ip\": \"1.1.1.1\",\n            \"name\": \"+44 9999999\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"txid\": \"1684599c-bb16-4250-af85-904291bfe7cc\",\n        \"event_type\": \"authentication\",\n        \"reason\": \"user_approved\",\n        \"access_device\": {\n            \"hostname\": null,\n            \"ip\": \"1.1.1.1\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"application\": {\n            \"key\": \"DIU6GEFWG5LIUTVV2M3N\",\n            \"name\": \"Shibboleth Integration Testing\"\n        },\n        \"factor\": \"duo_push\",\n        \"user\": {\n            \"key\": \"DUGL8U46QGJSOUJWG59W\",\n            \"name\": \"jdoe\"\n        }\n    }\n}";
        try {
            JWTClaimsSet claims = JWTClaimsSet.parse((String)jwtJson);
            return JWSAssemblyUtils.assembleMacJws((JWSAlgorithm)JWSAlgorithm.HS512, (JWTClaimsSet)claims, (byte[])JWSAssemblyUtils.getSecretBytes((String)this.integration.getSecretKey()));
        }
        catch (JOSEException | ParseException | EncodingException e) {
            throw new DuoClientException(e);
        }
    }

    public String getClientId() {
        return "MockDuoClient_OLD_AUTH_TIME";
    }

    public boolean isSupportsNonce() {
        return false;
    }

    public DuoOIDCClientCapabilities getCapabilities() {
        return new DuoOIDCClientCapabilities(){

            public boolean isSupportsNonce() {
                return false;
            }
        };
    }
}

