/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jose.JWSAlgorithm;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.ValidateTokenSignature;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateTokenSignatureTest
extends AbstractDuoActionTest {
    private ValidateTokenSignature action;

    @BeforeMethod
    public void setUp() throws Exception {
        super.setup();
        this.action = new ValidateTokenSignature();
        this.action.setSignatureAlgorithm(JWSAlgorithm.HS256);
    }

    @Test
    public final void testNoneSignature() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyToken("allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public final void testUnsuportedSignature() throws ComponentInitializationException, EncodingException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        String headerJson = "{\"typ\": \"JWT\",\"alg\": \"RS256\"}";
        this.dc.setAuthToken(this.createUnsignedSignedDummyToken("{\"typ\": \"JWT\",\"alg\": \"RS256\"}", "allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public final void testValidSignature() throws ComponentInitializationException, EncodingException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        String headerJson = "{\"typ\": \"JWT\",\"alg\": \"HS256\"}";
        this.dc.setAuthToken(this.createSignedDummyToken("{\"typ\": \"JWT\",\"alg\": \"HS256\"}", this.dc.getIntegration().getSecretKey(), "allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
    }

    @Test
    public final void testInvalidSignature() throws ComponentInitializationException, EncodingException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        String headerJson = "{\"typ\": \"JWT\",\"alg\": \"HS256\"}";
        String signature = "dGhpc2lzbm90Z29pbmd0b3dvcms=";
        this.dc.setAuthToken(this.createSignedDummyTokenFromGivenSignature("{\"typ\": \"JWT\",\"alg\": \"HS256\"}", "dGhpc2lzbm90Z29pbmd0b3dvcms=", "allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public final void testSignatureNotPresent() throws ComponentInitializationException, EncodingException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        String headerJson = "{\"typ\": \"JWT\",\"alg\": \"HS256\"}";
        this.dc.setAuthToken(this.createUnsignedSignedDummyToken("{\"typ\": \"JWT\",\"alg\": \"HS256\"}", "allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public final void testSetUnsupportedSignatureAlgorithm() {
        this.action.setSignatureAlgorithm(JWSAlgorithm.RS256);
    }
}

