/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.ValidateTokenClaims;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.security.jwt.claims.impl.ChainingJWTClaimsValidator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateTokenClaimsTest
extends AbstractDuoActionTest {
    private ValidateTokenClaims action;

    @BeforeMethod
    public void setUp() throws Exception {
        super.setup();
        this.action = new ValidateTokenClaims();
    }

    @Test
    public final void testValidToken() throws ComponentInitializationException {
        ChainingJWTClaimsValidator verifier = (ChainingJWTClaimsValidator)Mockito.mock(ChainingJWTClaimsValidator.class);
        this.action.setClaimsValidator((ClaimsValidator)verifier);
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyToken("allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now(), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
    }

    @Test
    public final void testInValidToken() throws ComponentInitializationException, JWTValidationException {
        ChainingJWTClaimsValidator verifier = (ChainingJWTClaimsValidator)Mockito.mock(ChainingJWTClaimsValidator.class);
        ((ChainingJWTClaimsValidator)Mockito.doThrow((Throwable[])new Throwable[]{new JWTValidationException("Invalid JWT")}).when((Object)verifier)).validate((JWTClaimsSet)Mockito.any(JWTClaimsSet.class), (ProfileRequestContext)Mockito.any());
        this.action.setClaimsValidator((ClaimsValidator)verifier);
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyToken("allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now(), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public final void testBlankJWT() throws ComponentInitializationException {
        ChainingJWTClaimsValidator verifier = (ChainingJWTClaimsValidator)Mockito.mock(ChainingJWTClaimsValidator.class);
        this.action.setClaimsValidator((ClaimsValidator)verifier);
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "InvalidAuthenticationContext");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public final void testNoClaimsVerifierSet() throws ComponentInitializationException {
        this.action.initialize();
    }
}

